/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.inventory.container;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integratedcrafting.RegistryEntries;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerPartInterfaceCraftingSettings
extends ContainerPartSettings {
    private final int lastChannelInterfaceCraftingValueId = this.getNextValueId();
    private final Map<IngredientComponent<?, ?>, Integer> targetSideOverrideValueIds = Maps.newIdentityHashMap();
    private final int lastDisableCraftingCheckValueId;

    public ContainerPartInterfaceCraftingSettings(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleContainer(0), PartHelpers.readPartTarget((FriendlyByteBuf)packetBuffer), Optional.empty(), PartHelpers.readPart((FriendlyByteBuf)packetBuffer));
    }

    public ContainerPartInterfaceCraftingSettings(int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, IPartType partType) {
        super(RegistryEntries.CONTAINER_INTERFACE_CRAFTING_SETTINGS, id, playerInventory, inventory, target, partContainer, partType);
        for (ResourceLocation key : Sets.newTreeSet((Iterable)IngredientComponent.REGISTRY.getKeys())) {
            IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(key);
            this.targetSideOverrideValueIds.put(ingredientComponent, this.getNextValueId());
        }
        this.lastDisableCraftingCheckValueId = this.getNextValueId();
    }

    protected int getPlayerInventoryOffsetY() {
        return 174;
    }

    protected void initializeValues() {
        super.initializeValues();
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastChannelInterfaceCraftingValueId, (int)((PartTypeInterfaceCrafting.State)this.getPartState()).getChannelCrafting());
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValues()) {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.getTargetSideOverrideValueId(ingredientComponent), (int)((PartTypeInterfaceCrafting.State)this.getPartState()).getIngredientComponentTargetSideOverride(ingredientComponent).ordinal());
        }
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisableCraftingCheckValueId, (boolean)((PartTypeInterfaceCrafting.State)this.getPartState()).isDisableCraftingCheck());
    }

    public int getLastChannelInterfaceCraftingValueId() {
        return this.lastChannelInterfaceCraftingValueId;
    }

    public int getLastChannelInterfaceValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastChannelInterfaceCraftingValueId);
    }

    public int getTargetSideOverrideValueId(IngredientComponent<?, ?> ingredientComponent) {
        return this.targetSideOverrideValueIds.get(ingredientComponent);
    }

    @Nullable
    public Direction getTargetSideOverrideValue(IngredientComponent<?, ?> ingredientComponent) {
        int i = ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.getTargetSideOverrideValueId(ingredientComponent));
        if (i < 0) {
            return this.getTarget().getTarget().getSide();
        }
        return Direction.values()[i];
    }

    public int getLastDisableCraftingCheckValueId() {
        return this.lastDisableCraftingCheckValueId;
    }

    public boolean getLastDisableCraftingCheckValue() {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.lastDisableCraftingCheckValueId);
    }

    public void setLastDisableCraftingCheckValue(boolean value) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisableCraftingCheckValueId, (boolean)value);
    }

    protected void updatePartSettings() {
        super.updatePartSettings();
        ((PartTypeInterfaceCrafting.State)this.getPartState()).setChannelCrafting(this.getLastChannelInterfaceValue());
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.getValues()) {
            ((PartTypeInterfaceCrafting.State)this.getPartState()).setIngredientComponentTargetSideOverride(ingredientComponent, this.getTargetSideOverrideValue(ingredientComponent));
        }
        ((PartTypeInterfaceCrafting.State)this.getPartState()).setDisableCraftingCheck(this.getLastDisableCraftingCheckValue());
    }
}

