/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeJEI;

public class SanguinaryEnvironmentalAccumulatorRecipeCategory
extends CommonEnvironmentalAccumulatorRecipeCategory<SanguinaryEnvironmentalAccumulatorRecipeJEI> {
    public static final RecipeType<SanguinaryEnvironmentalAccumulatorRecipeJEI> TYPE = RecipeType.create((String)"evilcraftcompat", (String)"sanguinary_environmental_accumulator", SanguinaryEnvironmentalAccumulatorRecipeJEI.class);
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int FLUID_SLOT = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public SanguinaryEnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Pair<Integer, Integer>)Pair.of((Object)42, (Object)8), (Pair<Integer, Integer>)Pair.of((Object)96, (Object)8));
        ResourceLocation resourceLocation = new ResourceLocation("evilcraftcompat", "textures/gui/sanguinary_environmental_accumulator_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return TYPE.getUid();
    }

    public Class<? extends SanguinaryEnvironmentalAccumulatorRecipeJEI> getRecipeClass() {
        return TYPE.getRecipeClass();
    }

    public RecipeType<SanguinaryEnvironmentalAccumulatorRecipeJEI> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent(RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.m_7705_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SanguinaryEnvironmentalAccumulatorRecipeJEI recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 42, 28).addItemStacks(recipe.getInputItems());
        FluidStack fluidStack = new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, AccumulateItemTickAction.getUsage(recipe.getCooldownTime()));
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).setOverlay(this.tankOverlay, 0, 0).setFluidRenderer(fluidStack.getAmount(), true, 16, 58).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluidStack);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 28).addItemStack(recipe.getOutputItem());
    }

    @Override
    public void draw(SanguinaryEnvironmentalAccumulatorRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.arrow.draw(matrixStack, 65, 28);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.m_92889_(matrixStack, (Component)duration, (float)((this.background.getWidth() - fontRenderer.m_92852_((FormattedText)duration)) / 2 + 12), 50.0f, -8355712);
    }
}

