/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.item.ItemPromise;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeJEI;

public class BloodInfuserRecipeCategory
implements IRecipeCategory<BloodInfuserRecipeJEI> {
    public static final RecipeType<BloodInfuserRecipeJEI> TYPE = RecipeType.create((String)"evilcraftcompat", (String)"blood_infuser", BloodInfuserRecipeJEI.class);
    private static final int INPUT_SLOT = 0;
    private static final int UPGRADE_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int FLUID_SLOT = 3;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public BloodInfuserRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("evilcraftcompat", "textures/gui/blood_infuser_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_BLOOD_INFUSER));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return TYPE.getUid();
    }

    public Class<? extends BloodInfuserRecipeJEI> getRecipeClass() {
        return TYPE.getRecipeClass();
    }

    public RecipeType<BloodInfuserRecipeJEI> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent(RegistryEntries.BLOCK_BLOOD_INFUSER.m_7705_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxTankSize(BloodInfuserRecipeJEI bloodInfuserRecipe) {
        return 10000 * BlockEntityWorking.getTankTierMultiplier(bloodInfuserRecipe.getInputTier());
    }

    protected ItemStack getPromise(BloodInfuserRecipeJEI bloodInfuserRecipe) {
        if (bloodInfuserRecipe.getInputTier() == 0) {
            return null;
        }
        return new ItemStack((ItemLike)ItemPromise.getItem(bloodInfuserRecipe.getInputTier()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BloodInfuserRecipeJEI recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 42, 28).addItemStacks(recipe.getInputItems());
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).setOverlay(this.tankOverlay, 0, 0).setFluidRenderer(this.getMaxTankSize(recipe), true, 16, 58).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getInputFluid());
        ItemStack promise = this.getPromise(recipe);
        if (promise != null) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 42, 8).addItemStack(promise);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 28).addItemStack(recipe.getOutputItem());
    }

    public void draw(BloodInfuserRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 65, 28);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.m_92889_(matrixStack, (Component)duration, (float)((this.background.getWidth() - fontRenderer.m_92852_((FormattedText)duration)) / 2 + 12), 50.0f, -8355712);
    }
}

