/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei;

import java.text.DecimalFormat;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenBloodInfuser;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenExaltedCrafter;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenOriginsOfDarkness;
import org.cyclops.evilcraft.client.gui.container.ContainerScreenSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraftcompat.RegistryEntriesCompat;
import org.cyclops.evilcraftcompat.modcompat.jei.SubtypeInterpreterActivatableFluidContainer;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser.BloodInfuserRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeJEI;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator.SanguinaryEnvironmentalAccumulatorRecipeJEI;

@JeiPlugin
public class JEIEvilCraftConfig
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        SubtypeInterpreterActivatableFluidContainer subtypeInterpreter = new SubtypeInterpreterActivatableFluidContainer();
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntries.ITEM_BLOOD_EXTRACTOR, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntries.ITEM_BLOOD_PEARL_OF_TELEPORTATION, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntries.ITEM_DARK_TANK, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntriesCompat.ITEM_INVIGORATING_PENDANT, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntriesCompat.ITEM_PRIMED_PENDANT, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntriesCompat.ITEM_KINETICATOR, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntriesCompat.ITEM_KINETICATOR_REPELLING, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntries.ITEM_MACE_OF_DISTORTION, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntriesCompat.ITEM_MACE_OF_DESTRUCTION, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntriesCompat.ITEM_NECROMANCER_STAFF, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntriesCompat.ITEM_FLESH_REJUVENATED, (IIngredientSubtypeInterpreter)subtypeInterpreter);
        subtypeRegistry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)RegistryEntries.ITEM_ENTANGLED_CHALICE, (IIngredientSubtypeInterpreter)subtypeInterpreter);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new BloodInfuserRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SanguinaryEnvironmentalAccumulatorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(BloodInfuserRecipeCategory.TYPE, BloodInfuserRecipeJEI.getAllRecipes());
        registry.addRecipes(EnvironmentalAccumulatorRecipeCategory.TYPE, EnvironmentalAccumulatorRecipeJEI.getAllRecipes());
        registry.addRecipes(SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE, SanguinaryEnvironmentalAccumulatorRecipeJEI.getAllRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_BLOOD_INFUSER), new RecipeType[]{BloodInfuserRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR), new RecipeType[]{EnvironmentalAccumulatorRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR), new RecipeType[]{SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.ITEM_EXALTED_CRAFTER), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN_EMPOWERED), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)RegistryEntries.ITEM_EXALTED_CRAFTER_EMPOWERED), new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerBloodInfuser.class, BloodInfuserRecipeCategory.TYPE, 1, 1, 7, 36);
        registry.addRecipeTransferHandler(ContainerSanguinaryEnvironmentalAccumulator.class, SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE, 0, 1, 6, 36);
        registry.addRecipeTransferHandler(ContainerExaltedCrafter.class, RecipeTypes.CRAFTING, 0, 9, 10, 63);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ContainerScreenBloodInfuser.class, 130, 36, 24, 16, new RecipeType[]{BloodInfuserRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenSanguinaryEnvironmentalAccumulator.class, 105, 36, 24, 16, new RecipeType[]{SanguinaryEnvironmentalAccumulatorRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenExaltedCrafter.class, 88, 32, 28, 23, new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addGuiScreenHandler(ContainerScreenOriginsOfDarkness.class, screen -> null);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("evilcraftcompat", "main");
    }

    public static MutableComponent getDurationSecondsTextComponent(int durationTicks) {
        String seconds = new DecimalFormat("#.##").format((double)durationTicks / 20.0);
        return new TranslatableComponent("gui.jei.category.smelting.time.seconds", new Object[]{seconds});
    }
}

