/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.structure;

import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.fml.config.ModConfig;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.extendedconfig.WorldStructureConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.world.gen.structure.WorldStructureDarkTemple;

public class WorldStructureDarkTempleConfig
extends WorldStructureConfig {
    @ConfigurableProperty(category="worldgeneration", comment="If dark temple should be added to all dimensions (except for the end and nether).", configLocation=ModConfig.Type.SERVER)
    public static boolean enabled = true;
    @ConfigurableProperty(category="worldgeneration", comment="Minimum block height at which a dark temple can spawn.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleMinHeight = 64;
    @ConfigurableProperty(category="worldgeneration", comment="Maximum blockState height at which a dark temple can spawn.", configLocation=ModConfig.Type.SERVER)
    public static int darkTempleMaxHeight = 90;
    public static int darkTempleSpacing = 40;
    public static int darkTempleSeparation = 16;
    public static final ResourceKey<StructureSet> STRUCTURE_SET_ID = ResourceKey.m_135785_((ResourceKey)Registry.f_211073_, (ResourceLocation)new ResourceLocation("evilcraft", "dark_temple"));
    public static Holder<ConfiguredStructureFeature<?, ?>> CONFIGURED_FEATURE;
    public static Holder<StructurePieceType> PIECE_TYPE;
    public static Holder<StructureSet> STRUCTURE_SET;

    public WorldStructureDarkTempleConfig() {
        super((ModBase)EvilCraft._instance, "dark_temple", eConfig -> new WorldStructureDarkTemple((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    }

    public void onForgeRegistered() {
        super.onForgeRegistered();
        PIECE_TYPE = BuiltinRegistries.m_206396_((Registry)Registry.f_122843_, (String)"evilcraft:dark_temple_piece", WorldStructureDarkTemple.Piece::new);
        CONFIGURED_FEATURE = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), this.getNamedId() + "_default"), (Object)((WorldStructureDarkTemple)((Object)this.getInstance())).m_209762_((FeatureConfiguration)FeatureConfiguration.f_67737_, TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("evilcraft", "has_structure/dark_temple"))));
        STRUCTURE_SET = BuiltinRegistries.m_206384_((Registry)BuiltinRegistries.f_211084_, STRUCTURE_SET_ID, (Object)new StructureSet(CONFIGURED_FEATURE, (StructurePlacement)new RandomSpreadStructurePlacement(darkTempleSpacing, darkTempleSeparation, RandomSpreadType.TRIANGULAR, 370458167)));
    }
}

