/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.entity.item.EntityWeatherContainer;

public class ItemWeatherContainer
extends Item {
    public ItemWeatherContainer(Item.Properties properties) {
        super(properties);
    }

    public static WeatherContainerType getWeatherType(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            try {
                return WeatherContainerType.valueOf(tag.m_128461_("weather"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return WeatherContainerType.EMPTY;
    }

    public static void setWeatherType(ItemStack itemStack, WeatherContainerType type) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_("weather", type.name());
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!world.m_5776_() && ItemWeatherContainer.getWeatherType(itemStack) != WeatherContainerType.EMPTY) {
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.f_46441_.nextFloat() * 0.4f + 0.8f));
            EntityWeatherContainer entity = new EntityWeatherContainer(world, (LivingEntity)player, itemStack.m_41777_());
            entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
            world.m_7967_((Entity)entity);
            itemStack.m_41774_(1);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public void onUse(ServerLevel world, ItemStack itemStack) {
        ItemWeatherContainer.getWeatherType(itemStack).onUse(world, itemStack);
    }

    public void onFill(ServerLevel world, ItemStack itemStack) {
        ItemWeatherContainer.getWeatherType(itemStack).onFill(world, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        WeatherContainerType type = ItemWeatherContainer.getWeatherType(itemStack);
        list.add((Component)type.description.m_130940_(type.damageColor));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            for (WeatherContainerType type : WeatherContainerType.values()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemWeatherContainer.setWeatherType(stack, type);
                items.add((Object)stack);
            }
        }
    }

    public Rarity m_41460_(ItemStack itemStack) {
        return ItemWeatherContainer.getWeatherType((ItemStack)itemStack).rarity;
    }

    public static enum WeatherContainerType {
        EMPTY(null, "empty", ChatFormatting.GRAY, Helpers.RGBToInt((int)125, (int)125, (int)125), Rarity.COMMON),
        CLEAR(WeatherType.CLEAR, "clear", ChatFormatting.AQUA, Helpers.RGBToInt((int)30, (int)150, (int)230), Rarity.UNCOMMON),
        RAIN(WeatherType.RAIN, "rain", ChatFormatting.DARK_BLUE, Helpers.RGBToInt((int)0, (int)0, (int)255), Rarity.UNCOMMON),
        LIGHTNING(WeatherType.LIGHTNING, "lightning", ChatFormatting.GOLD, Helpers.RGBToInt((int)255, (int)215, (int)0), Rarity.RARE);

        private final WeatherType type;
        private final MutableComponent description;
        private final ChatFormatting damageColor;
        private final int damageRenderColor;
        private final Rarity rarity;

        private WeatherContainerType(WeatherType type, String description, ChatFormatting damageColor, int damageRenderColor, Rarity rarity) {
            this.type = type;
            this.description = new TranslatableComponent("weather_container.evilcraft." + description);
            this.damageColor = damageColor;
            this.damageRenderColor = damageRenderColor;
            this.rarity = rarity;
        }

        public void onFill(ServerLevel world, ItemStack containerStack) {
            WeatherContainerType currentWeatherType = EMPTY;
            for (WeatherContainerType type : WeatherContainerType.values()) {
                if (type.type == null || !type.type.isActive((Level)world)) continue;
                currentWeatherType = type;
            }
            ItemWeatherContainer.setWeatherType(containerStack, currentWeatherType);
            currentWeatherType.type.deactivate(world);
        }

        public void onUse(ServerLevel world, ItemStack containerStack) {
            if (world.m_5776_()) {
                return;
            }
            if (this.type != null) {
                this.type.activate(world);
            }
            ItemWeatherContainer.setWeatherType(containerStack, EMPTY);
        }

        public static WeatherContainerType getWeatherContainerType(WeatherType weatherType) {
            for (WeatherContainerType type : WeatherContainerType.values()) {
                if (type.type != weatherType) continue;
                return type;
            }
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int m_92671_(ItemStack itemStack, int renderPass) {
            return renderPass > 0 ? 0xFFFFFF : ItemWeatherContainer.getWeatherType((ItemStack)itemStack).damageRenderColor;
        }
    }
}

