/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class ItemPowerableHelpers {
    private static final String NBT_KEY_POWER = "power";

    public static int getPower(ItemStack itemStack) {
        return ItemHelpers.getNBTInt(itemStack, NBT_KEY_POWER);
    }

    public static void setPower(ItemStack itemStack, int power) {
        ItemHelpers.setNBTInt(itemStack, power, NBT_KEY_POWER);
    }

    public static boolean onPowerableItemItemRightClick(ItemStack itemStack, Level world, Player player, int powerLevels, boolean onSneak) {
        if (onSneak == player.m_6047_()) {
            if (!world.m_5776_()) {
                int newPower = (ItemPowerableHelpers.getPower(itemStack) + 1) % powerLevels;
                ItemPowerableHelpers.setPower(itemStack, newPower);
                player.m_5661_((Component)new TranslatableComponent("item.evilcraft.powerable.set_power", new Object[]{newPower}).m_130940_(ChatFormatting.DARK_PURPLE), true);
            }
            return true;
        }
        return false;
    }

    public static void addPreInformation(ItemStack itemStack, List<Component> lines) {
        L10NHelpers.addOptionalInfo(lines, (String)"item.evilcraft.powerable");
    }

    public static void addPostInformation(ItemStack itemStack, List<Component> lines) {
        lines.add((Component)new TranslatableComponent("item.evilcraft.powerable.info.power", new Object[]{ItemPowerableHelpers.getPower(itemStack)}).m_130940_(ChatFormatting.BOLD));
    }
}

