/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.item.EntityItemEmpowerable;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class ItemExaltedCrafter
extends ItemGui
implements IItemEmpowerable {
    private static final String NBT_RETURNTOINNER = "returnToInner";
    private static final String NBT_INVENTORY = "inventory";
    private final boolean wooden;
    private final boolean empowered;

    public ItemExaltedCrafter(Item.Properties properties, boolean wooden, boolean empowered) {
        super(properties);
        this.wooden = wooden;
        this.empowered = empowered;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return this.isEmpowered(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rarity m_41460_(ItemStack itemStack) {
        return this.isEmpowered(itemStack) ? Rarity.UNCOMMON : super.m_41460_(itemStack);
    }

    @Override
    public boolean isEmpowered(ItemStack itemStack) {
        return this.empowered;
    }

    @Override
    public ItemStack empower(ItemStack itemStack) {
        ItemStack newStack = new ItemStack((ItemLike)(this.wooden ? RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN_EMPOWERED : RegistryEntries.ITEM_EXALTED_CRAFTER_EMPOWERED));
        if (itemStack.m_41782_()) {
            newStack.m_41751_(itemStack.m_41783_().m_6426_());
        }
        return newStack;
    }

    public Container getSupplementaryInventory(Player player, ItemLocation itemLocation) {
        if (this.wooden) {
            return new NBTSimpleInventoryItemHeld(player, itemLocation, 27, 64, NBT_INVENTORY);
        }
        return player.m_36327_();
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemStack) {
        return new EntityItemEmpowerable(world, (ItemEntity)location);
    }

    public static void setReturnToInner(ItemStack itemStack, boolean returnToInner) {
        if (itemStack.m_41782_()) {
            itemStack.m_41783_().m_128379_(NBT_RETURNTOINNER, returnToInner);
        }
    }

    public static boolean isReturnToInner(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return itemStack.m_41783_().m_128471_(NBT_RETURNTOINNER);
        }
        return false;
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, itemLocation.getItemStack(playerEntity).m_41786_(), ContainerExaltedCrafter::new);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerExaltedCrafter.class;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.m_5776_()) {
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.wooden ? SoundEvents.f_11749_ : SoundEvents.f_11889_, SoundSource.BLOCKS, 0.5f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
        return super.m_7203_(world, player, hand);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        ItemHandler itemHandler = new ItemHandler(stack);
        return new ICapabilityProvider(){
            final /* synthetic */ IItemHandler val$itemHandler;
            {
                this.val$itemHandler = iItemHandler;
            }

            public <T> LazyOptional getCapability(Capability<T> capability, Direction facing) {
                return ItemExaltedCrafter.this.wooden && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(() -> this.val$itemHandler) : LazyOptional.empty();
            }
        };
    }

    public class ItemHandler
    implements IItemHandlerModifiable {
        protected ItemStack itemStack;

        public ItemHandler(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        protected NonNullList<ItemStack> getItemList() {
            NonNullList itemStacks = NonNullList.m_122780_((int)this.getSlots(), (Object)ItemStack.f_41583_);
            CompoundTag rootTag = this.itemStack.m_41783_();
            if (rootTag != null && rootTag.m_128425_(ItemExaltedCrafter.NBT_INVENTORY, 9)) {
                ListTag nbttaglist = rootTag.m_128437_(ItemExaltedCrafter.NBT_INVENTORY, 10);
                for (int j = 0; j < nbttaglist.size(); ++j) {
                    CompoundTag slot = nbttaglist.m_128728_(j);
                    int index = slot.m_128441_("index") ? slot.m_128451_("index") : (int)slot.m_128445_("Slot");
                    if (index < 0 || index >= this.getSlots()) continue;
                    itemStacks.set(index, (Object)ItemStack.m_41712_((CompoundTag)slot));
                }
            }
            return itemStacks;
        }

        protected void setItemList(NonNullList<ItemStack> itemStacks) {
            CompoundTag rootTag = this.itemStack.m_41784_();
            ListTag slots = new ListTag();
            for (byte index = 0; index < this.getSlots(); index = (byte)((byte)(index + 1))) {
                ItemStack itemStack = (ItemStack)itemStacks.get((int)index);
                if (itemStack.m_41619_() || itemStack.m_41613_() <= 0) continue;
                CompoundTag slot = new CompoundTag();
                slots.add((Object)slot);
                slot.m_128344_("Slot", index);
                itemStack.m_41739_(slot);
            }
            rootTag.m_128365_(ItemExaltedCrafter.NBT_INVENTORY, (Tag)slots);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            NonNullList<ItemStack> itemStacks = this.getItemList();
            itemStacks.set(slot, (Object)stack);
            this.setItemList(itemStacks);
        }

        public int getSlots() {
            return 27;
        }

        public ItemStack getStackInSlot(int slot) {
            return (ItemStack)this.getItemList().get(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            NonNullList<ItemStack> itemStacks = this.getItemList();
            ItemStack existingStack = (ItemStack)itemStacks.get(slot);
            if (!existingStack.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack)) {
                    return stack;
                }
                int maxStackSize = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - existingStack.m_41613_();
                if (stack.m_41613_() <= maxStackSize) {
                    if (!simulate) {
                        ItemStack copy = stack.m_41777_();
                        copy.m_41769_(existingStack.m_41613_());
                        this.setStackInSlot(slot, copy);
                    }
                    return ItemStack.f_41583_;
                }
                stack = stack.m_41777_();
                if (!simulate) {
                    ItemStack copy = stack.m_41620_(maxStackSize);
                    copy.m_41769_(existingStack.m_41613_());
                    this.setStackInSlot(slot, copy);
                    return stack;
                }
                stack.m_41774_(maxStackSize);
                return stack;
            }
            int maxStackSize = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
            if (maxStackSize < stack.m_41613_()) {
                stack = stack.m_41777_();
                if (!simulate) {
                    this.setStackInSlot(slot, stack.m_41620_(maxStackSize));
                    return stack;
                }
                stack.m_41774_(maxStackSize);
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack);
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            ItemStack existingStack = this.getStackInSlot(slot);
            if (existingStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack extracted = existingStack.m_41620_(amount);
            if (!simulate) {
                this.setStackInSlot(slot, existingStack);
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

