/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook.pageelement;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public class EnvironmentalAccumulatorRecipeAppendix
extends RecipeAppendix<RecipeEnvironmentalAccumulator> {
    private static final ResourceLocation WEATHERS = new ResourceLocation("evilcraft", "textures/gui/weathers.png");
    private static final Map<WeatherType, Integer> X_ICON_OFFSETS = new HashMap<WeatherType, Integer>();
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int START_X_RESULT = 68;
    private static final int Y_START = 2;
    private static final AdvancedButtonEnum INPUT;
    private static final AdvancedButtonEnum RESULT;

    public EnvironmentalAccumulatorRecipeAppendix(IInfoBook infoBook, RecipeEnvironmentalAccumulator recipe) {
        super(infoBook, (Object)recipe);
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return 42;
    }

    protected String getUnlocalizedTitle() {
        return "block.evilcraft.environmental_accumulator";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        boolean sanguinary = this.getTick(gui) % 2 == 1;
        int middle = (width - 16) / 2;
        gui.drawArrowRight(matrixStack, x + middle - 3, y + 23 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStacks(((RecipeEnvironmentalAccumulator)this.recipe).getInputIngredient().m_43908_(), tick);
        ItemStack result = this.prepareItemStack(((RecipeEnvironmentalAccumulator)this.recipe).getOutputItemFirst(), tick);
        this.renderItem(gui, matrixStack, x + 16, y + 23, input, mx, my, INPUT);
        this.renderItem(gui, matrixStack, x + 68, y + 23, result, mx, my, RESULT);
        this.renderItem(gui, matrixStack, x + middle, y + 23, new ItemStack((ItemLike)(sanguinary ? RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR : RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR)), mx, my, false, null);
        Integer inputX = X_ICON_OFFSETS.get(((RecipeEnvironmentalAccumulator)this.recipe).getInputWeather());
        if (inputX != null) {
            RenderHelpers.bindTexture((ResourceLocation)WEATHERS);
            gui.m_93228_(matrixStack, x + 16, y + 2, inputX.intValue(), 0, 16, 16);
            gui.drawOuterBorder(matrixStack, x + 16, y + 2, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
            Integer outputX = X_ICON_OFFSETS.get(((RecipeEnvironmentalAccumulator)this.recipe).getOutputWeather());
            RenderHelpers.bindTexture((ResourceLocation)WEATHERS);
            gui.m_93228_(matrixStack, x + 68, y + 2, outputX.intValue(), 0, 16, 16);
            gui.drawOuterBorder(matrixStack, x + 68, y + 2, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (sanguinary) {
            this.renderItem(gui, matrixStack, x + middle, y + 2, ItemHelpers.getBloodBucket(), mx, my, false, null);
            Font fontRenderer = gui.getFont();
            int amount = AccumulateItemTickAction.getUsage(((RecipeEnvironmentalAccumulator)this.recipe).getCooldownTime());
            FluidStack fluidStack = new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, amount);
            String line = fluidStack.getAmount() + " mB";
            MultiLineLabel.m_94341_((Font)fontRenderer, (FormattedText)new TextComponent(line), (int)200).m_6508_(matrixStack, x + middle - 5, y + 16, 9, 0);
        }
    }

    static {
        X_ICON_OFFSETS.put(WeatherType.CLEAR, 0);
        X_ICON_OFFSETS.put(WeatherType.RAIN, 16);
        X_ICON_OFFSETS.put(WeatherType.LIGHTNING, 32);
        INPUT = AdvancedButtonEnum.create();
        RESULT = AdvancedButtonEnum.create();
    }
}

