/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.evilcraft.RegistryEntries;

public class EntityWerewolf
extends Monster {
    private CompoundTag villagerNBTTagCompound = new CompoundTag();
    private boolean fromVillager = false;
    private static final int BARKCHANCE = 1000;
    private static final int BARKLENGTH = 40;
    private static int barkprogress;

    public EntityWerewolf(EntityType<? extends EntityWerewolf> type, Level world) {
        super(type, world);
    }

    public EntityWerewolf(Level world) {
        super(RegistryEntries.ENTITY_WEREWOLF, world);
        this.f_19793_ = 1.0f;
        this.villagerNBTTagCompound.m_128359_("ProfessionName", RegistryEntries.VILLAGER_PROFESSION_WEREWOLF.getRegistryName().toString());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void transformWerewolfVillager(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof Villager && !event.getEntity().f_19853_.m_5776_()) {
            Villager villager = (Villager)event.getEntity();
            if (EntityWerewolf.isWerewolfTime(event.getEntity().f_19853_) && villager.m_7141_().m_35571_() == RegistryEntries.VILLAGER_PROFESSION_WEREWOLF && villager.f_19853_.m_45517_(LightLayer.SKY, villager.m_142538_()) > 0) {
                EntityWerewolf.replaceVillager(villager);
            }
        }
    }

    public float m_6100_() {
        return super.m_6100_() * 0.75f;
    }

    public void m_7380_(CompoundTag NBTTagCompound) {
        super.m_7380_(NBTTagCompound);
        NBTTagCompound.m_128365_("villager", (Tag)this.villagerNBTTagCompound);
        NBTTagCompound.m_128379_("fromVillager", this.fromVillager);
    }

    public void m_7378_(CompoundTag NBTTagCompound) {
        super.m_7378_(NBTTagCompound);
        this.villagerNBTTagCompound = NBTTagCompound.m_128469_("villager");
        this.fromVillager = NBTTagCompound.m_128471_("fromVillager");
    }

    public static boolean isWerewolfTime(Level world) {
        return (double)world.m_46940_() == 1.0 && !world.m_46461_() && world.m_46791_() != Difficulty.PEACEFUL;
    }

    private static void replaceEntity(Mob old, Mob neww, Level world) {
        neww.m_20359_((Entity)old);
        old.m_142687_(Entity.RemovalReason.DISCARDED);
        world.m_7967_((Entity)neww);
        world.m_5898_(null, 1016, old.m_142538_(), 0);
    }

    public void replaceWithVillager() {
        Villager villager = new Villager(EntityType.f_20492_, this.f_19853_, VillagerType.m_204073_((Holder)this.f_19853_.m_204166_(this.m_142538_())));
        EntityWerewolf.initializeWerewolfVillagerData(villager);
        EntityWerewolf.replaceEntity((Mob)this, (Mob)villager, this.f_19853_);
        try {
            villager.m_7378_(this.villagerNBTTagCompound);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static void initializeWerewolfVillagerData(Villager villager) {
        villager.m_141967_(villager.m_7141_().m_35561_(2).m_35565_(RegistryEntries.VILLAGER_PROFESSION_WEREWOLF));
    }

    public static void replaceVillager(Villager villager) {
        EntityWerewolf werewolf = new EntityWerewolf(villager.f_19853_);
        villager.m_7380_(werewolf.getVillagerNBTTagCompound());
        werewolf.setFromVillager(true);
        EntityWerewolf.replaceEntity((Mob)villager, (Mob)werewolf, villager.f_19853_);
    }

    public void m_8107_() {
        if (!(this.f_19853_.m_5776_() || EntityWerewolf.isWerewolfTime(this.f_19853_) && this.f_19853_.m_46791_() != Difficulty.PEACEFUL)) {
            this.replaceWithVillager();
        } else {
            super.m_8107_();
        }
        Random random = this.f_19853_.f_46441_;
        if (random.nextInt(1000) == 0 && barkprogress == -1) {
            ++barkprogress;
        } else if (barkprogress > -1) {
            this.m_5496_(SoundEvents.f_12619_, 0.15f, 1.0f);
            if (++barkprogress > 40) {
                barkprogress = -1;
            }
        }
    }

    public float getBarkProgressScaled(float scale) {
        if (barkprogress == -1) {
            return 0.0f;
        }
        return (float)barkprogress / 40.0f * scale;
    }

    public ResourceLocation m_7582_() {
        return new ResourceLocation("evilcraft", "entities/werewolf");
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12619_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12621_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState block) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return super.m_6785_(distanceToClosestPlayer) && !this.isFromVillager();
    }

    public CompoundTag getVillagerNBTTagCompound() {
        return this.villagerNBTTagCompound;
    }

    public boolean isFromVillager() {
        return this.fromVillager;
    }

    public void setFromVillager(boolean fromVillager) {
        this.fromVillager = fromVillager;
    }

    static {
        MinecraftForge.EVENT_BUS.register(EntityWerewolf.class);
        barkprogress = -1;
    }
}

