/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.effect;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class EntityAntiVengeanceBeam
extends ThrowableProjectile {
    private static final int MAX_AGE = 200;
    private int age = 0;
    private int soundTick = 0;

    public EntityAntiVengeanceBeam(EntityType<? extends EntityAntiVengeanceBeam> type, Level world) {
        super(type, world);
        this.m_20256_(this.m_20184_().m_82542_(0.25, 0.25, 0.25));
    }

    public EntityAntiVengeanceBeam(EntityType<? extends EntityAntiVengeanceBeam> type, Level world, LivingEntity entity) {
        super(type, entity, world);
        this.m_20256_(this.m_20184_().m_82542_(0.25, 0.25, 0.25));
    }

    public EntityAntiVengeanceBeam(Level world, LivingEntity entity) {
        super(RegistryEntries.ENTITY_ANTI_VENGEANCE_BEAM, entity, world);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> !entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && entity != this.m_37282_());
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        Vec3 motion = this.m_20184_();
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 vec31 = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82549_(motion);
        EntityHitResult entityRayTraceResult = this.rayTraceEntities(vec3, vec31);
        vec3 = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        vec31 = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82549_(motion);
        ++this.soundTick;
        if (this.soundTick > 3 && this.m_142049_() % 10 == 0) {
            this.soundTick = 0;
        }
        if (!this.f_19853_.m_5776_()) {
            Entity entity = null;
            List list = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82383_(motion).m_82400_(1.0));
            double d0 = 0.0;
            for (Entity entity1 : list) {
                double d1;
                if (!(entity1 instanceof EntityVengeanceSpirit) || ((EntityVengeanceSpirit)entity1).isSwarm()) continue;
                float f = 0.3f;
                AABB axisalignedbb = entity1.m_142469_().m_82400_((double)f);
                EntityHitResult movingobjectposition1 = ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)vec3, (Vec3)vec31, (AABB)axisalignedbb, e -> true);
                if (movingobjectposition1 == null || !((d1 = vec3.m_82554_(movingobjectposition1.m_82450_())) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                entityRayTraceResult = new EntityHitResult(entity);
            }
        } else {
            for (int i = 0; i < this.f_19853_.f_46441_.nextInt(5) + 5; ++i) {
                this.showNewBlurParticle();
            }
            if (this.soundTick == 1) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), EvilCraftSoundEvents.effect_vengeancebeam_base, SoundSource.NEUTRAL, 0.5f + this.f_19853_.f_46441_.nextFloat() * 0.2f, 1.0f, false);
            }
        }
        if (entityRayTraceResult != null) {
            this.m_6532_((HitResult)entityRayTraceResult);
        }
        if (this.age++ > 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void showNewBlurParticle() {
        float scale = 0.6f - this.f_19796_.nextFloat() * 0.3f;
        float red = this.f_19796_.nextFloat() * 0.03f + 0.01f;
        float green = this.f_19796_.nextFloat() * 0.03f;
        float blue = this.f_19796_.nextFloat() * 0.05f + 0.05f;
        float ageMultiplier = (float)(this.f_19796_.nextDouble() * 6.5 + 4.0);
        Vec3 motion = this.m_20184_();
        Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), false, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.deriveMotion(motion.f_82479_), this.deriveMotion(motion.f_82480_), this.deriveMotion(motion.f_82481_));
    }

    private double deriveMotion(double motion) {
        return motion * 0.5 + (0.02 - this.f_19796_.nextDouble() * 0.04);
    }

    protected void applyHitEffect(Entity entity) {
        if (entity instanceof EntityVengeanceSpirit) {
            EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)entity;
            Vec3 motion = this.m_20184_();
            spirit.onHit(this.m_20185_(), this.m_20186_(), this.m_20189_(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
            Entity entity2 = this.m_37282_();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer owner = (ServerPlayer)entity2;
                spirit.addEntanglingPlayer(owner);
            }
        }
    }

    protected void m_6532_(HitResult position) {
        if (!this.f_19853_.m_5776_() && position.m_6662_() == HitResult.Type.ENTITY && this.m_37282_() != null && this.m_37282_() instanceof ServerPlayer) {
            this.applyHitEffect(((EntityHitResult)position).m_82443_());
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }
}

