/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.block.EntityLightningBombPrimedConfig;

public class EntityLightningBombPrimed
extends PrimedTnt {
    private static final float EXPLOSION_STRENGTH = 1.0f;
    @Nullable
    private LivingEntity placer;

    public EntityLightningBombPrimed(EntityType<? extends EntityLightningBombPrimed> type, Level world) {
        super(type, world);
        this.setFuse();
    }

    public EntityLightningBombPrimed(Level world, double x, double y, double z, @Nullable LivingEntity placer) {
        this(RegistryEntries.ENTITY_LIGHTNING_BOMB_PRIMED, world);
        this.m_6034_(x, y, z);
        double d0 = world.f_46441_.nextDouble() * 6.2831854820251465;
        this.m_20334_(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.m_32085_(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.placer = placer;
        this.setFuse();
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public LivingEntity m_32099_() {
        return this.placer;
    }

    protected void setFuse() {
        this.m_32085_(EntityLightningBombPrimedConfig.fuse);
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        if (this.m_32100_() - 1 <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (!this.f_19853_.m_5776_()) {
                this.explode(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
        } else {
            this.m_32085_(this.m_32100_() - 1);
            this.m_5841_();
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void explode(Level world, double x, double y, double z) {
        if (!world.m_5776_()) {
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Explosion.BlockInteraction.DESTROY);
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            bolt.m_6027_(x, y, z);
        } else {
            Random rand = new Random();
            for (int i = 0; i < 32; ++i) {
                Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)ParticleTypes.f_123797_, false, x, y + rand.nextDouble() * 2.0, z, rand.nextGaussian(), 0.0, rand.nextGaussian());
            }
        }
    }
}

