/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class RecipeSerializerBloodInfuser
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RecipeBloodInfuser> {
    public RecipeBloodInfuser fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)false);
        FluidStack inputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)json, (String)"fluid", (boolean)false);
        int inputTier = GsonHelper.m_13824_((JsonObject)json, (String)"tier", (int)0);
        Either outputItemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)result, (boolean)false);
        int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        float xp = GsonHelper.m_13820_((JsonObject)json, (String)"xp", (float)0.0f);
        if (inputIngredient.m_43947_() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (outputItemStack.left().isPresent() && outputItemStack.left().isEmpty()) {
            throw new JsonSyntaxException("An output item is required");
        }
        if (inputTier < 0) {
            throw new JsonSyntaxException("Tiers can not be negative");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        if (xp < 0.0f) {
            throw new JsonSyntaxException("XP can not be negative");
        }
        return new RecipeBloodInfuser(recipeId, inputIngredient, inputFluid, inputTier, (Either<ItemStack, ItemStackFromIngredient>)outputItemStack, duration, xp);
    }

    @Nullable
    public RecipeBloodInfuser fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        FluidStack inputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        int inputTier = buffer.m_130242_();
        Either outputItem = RecipeSerializerHelpers.readItemStackOrItemStackIngredient((FriendlyByteBuf)buffer);
        int duration = buffer.m_130242_();
        float xp = buffer.readFloat();
        return new RecipeBloodInfuser(recipeId, inputIngredient, inputFluid, inputTier, (Either<ItemStack, ItemStackFromIngredient>)outputItem, duration, xp);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeBloodInfuser recipe) {
        recipe.getInputIngredient().m_43923_(buffer);
        recipe.getInputFluid().writeToPacket(buffer);
        buffer.m_130130_(recipe.getInputTier());
        RecipeSerializerHelpers.writeItemStackOrItemStackIngredient((FriendlyByteBuf)buffer, recipe.getOutputItem());
        buffer.m_130130_(recipe.getDuration());
        buffer.writeFloat(recipe.getXp());
    }
}

