/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTank;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.item.ItemBloodExtractor;

public class RecipeBloodExtractorCombination
extends CustomRecipe {
    private final int maxCapacity;

    public RecipeBloodExtractorCombination(ResourceLocation id, int maxCapacity) {
        super(id);
        this.maxCapacity = maxCapacity;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingContainer grid, Level world) {
        return !this.assemble(grid).m_41619_();
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)RegistryEntries.ITEM_BLOOD_EXTRACTOR);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList aitemstack = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_BLOODEXTRACTOR_COMBINATION;
    }

    public ItemStack assemble(CraftingContainer grid) {
        ItemStack output = this.m_8043_().m_41777_();
        int totalCapacity = 0;
        int totalContent = 0;
        int extractors = 0;
        int tanks = 0;
        for (int j = 0; j < grid.m_6643_(); ++j) {
            FluidStack fluidStack;
            ItemStack element = grid.m_8020_(j).m_41777_().m_41620_(1);
            if (element.m_41619_()) continue;
            if (element.m_41720_() instanceof BlockItem && ((BlockItem)element.m_41720_()).m_40614_() instanceof BlockDarkTank) {
                tanks += element.m_41613_();
                fluidStack = FluidUtil.getFluidContained((ItemStack)element).orElse(FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    if (fluidStack.getFluid() != RegistryEntries.FLUID_BLOOD) {
                        return ItemStack.f_41583_;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)(fluidStack.getAmount() * element.m_41613_()));
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)(FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element).map(IFluidHandlerItemCapacity::getCapacity).orElse(0) * element.m_41613_()));
                continue;
            }
            if (element.m_41720_() instanceof ItemBloodExtractor) {
                extractors += element.m_41613_();
                fluidStack = FluidUtil.getFluidContained((ItemStack)element).orElse(FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    if (fluidStack.getFluid() != RegistryEntries.FLUID_BLOOD) {
                        return ItemStack.f_41583_;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)(fluidStack.getAmount() * element.m_41613_()));
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)(FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element).map(IFluidHandlerItemCapacity::getCapacity).orElse(0) * element.m_41613_()));
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (extractors + tanks < 2 || extractors < 1 || totalCapacity > BlockDarkTankConfig.maxTankSize) {
            return ItemStack.f_41583_;
        }
        IFluidHandlerItemCapacity fluidHandlerOutput = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)output).orElse(null);
        fluidHandlerOutput.setCapacity(totalCapacity);
        fluidHandlerOutput.fill(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, totalContent), IFluidHandler.FluidAction.EXECUTE);
        return output;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }
}

