/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.cyclops.evilcraft.EvilCraft;

public class ImplicitFluidConverter {
    private static final String DELIMITER = ":";
    private Fluid target;
    private Map<Fluid, Double> converters = Maps.newHashMap();

    public ImplicitFluidConverter(Fluid target) {
        this.setTarget(target);
    }

    public void setTarget(Fluid target) {
        this.target = target;
        if (target != null) {
            this.converters.put(target, 1.0);
        }
    }

    public Fluid getTarget() {
        return this.target;
    }

    public void addConverter(Fluid fluid, double rate) {
        if (fluid != null) {
            EvilCraft.clog("Register fluid conversion for " + fluid.getRegistryName() + " with ratio " + rate);
            this.converters.put(fluid, rate);
        }
    }

    public boolean canConvert(Fluid fluid) {
        return this.converters.containsKey(fluid);
    }

    public FluidStack convert(FluidStack fluid) {
        if (!fluid.isEmpty() && this.canConvert(fluid.getFluid())) {
            return new FluidStack(this.target, (int)Math.floor((double)fluid.getAmount() * this.converters.get(fluid.getFluid())));
        }
        return FluidStack.EMPTY;
    }

    public FluidStack convertReverse(Fluid target, FluidStack fluid) {
        if (this.canConvert(target) && !fluid.isEmpty() && fluid.getFluid() == this.target) {
            FluidStack ret = fluid.copy();
            return new FluidStack(target, (int)Math.floor((double)ret.getAmount() / this.converters.get(target)));
        }
        return FluidStack.EMPTY;
    }

    public double getRatio(Fluid target) {
        return this.converters.get(target);
    }

    public void registerFromConfig(String[] config) {
        for (String line : config) {
            String[] split = line.split(DELIMITER);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a fluid converter config.");
            }
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(split[0]));
            if (fluid == null) {
                EvilCraft.clog("Could not find a fluid by name '" + split[0] + "' for a fluid converter config.", Level.WARN);
            }
            double ratio = 1.0;
            try {
                ratio = Double.parseDouble(split[1]);
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid ratio '" + split[1] + "' in a fluid converter config, using 1.0.", Level.ERROR);
            }
            this.addConverter(fluid, ratio);
        }
    }
}

