/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.blockentity.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradable;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;

public class Upgrades {
    private static final Map<String, Upgrade> upgradeMap = Maps.newHashMap();
    public static final int TIERS = 3;
    public static final Upgrade UPGRADE_TIER1 = Upgrades.getUpgrade("tier", 1);
    public static final Upgrade UPGRADE_TIER2 = Upgrades.getUpgrade("tier", 2);
    public static final Upgrade UPGRADE_TIER3 = Upgrades.getUpgrade("tier", 3);
    public static final Upgrade UPGRADE_SPEED = Upgrades.getUpgrade("speed");
    public static final Upgrade UPGRADE_EFFICIENCY = Upgrades.getUpgrade("efficiency");

    public static Collection<Upgrade> getUpgrades() {
        return upgradeMap.values();
    }

    public static Upgrade getUpgrade(String upgradeId, int tier) {
        Upgrade upgrade = upgradeMap.get(upgradeId + tier);
        if (upgrade == null) {
            upgrade = new Upgrade(upgradeId, tier);
            upgradeMap.put(upgradeId + tier, upgrade);
        }
        return upgrade;
    }

    public static Upgrade getUpgrade(String upgradeId) {
        return Upgrades.getUpgrade(upgradeId, 0);
    }

    public static UpgradeEventType newUpgradeEventType() {
        return new UpgradeEventType();
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event) {
        Upgrades.sendEvent(upgradable, event, upgradable.getUpgradeBehaviour().keySet());
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event, Upgrade upgrade) {
        Upgrades.sendEvent(upgradable, event, Lists.newArrayList((Object[])new Upgrade[]{upgrade}));
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event, Upgrade ... upgrades) {
        Upgrades.sendEvent(upgradable, event, Lists.newArrayList((Object[])upgrades));
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event, Collection<Upgrade> upgrades) {
        for (Upgrade upgrade : upgrades) {
            IUpgradeBehaviour<T, O> behaviour = upgradable.getUpgradeBehaviour().get(upgrade);
            int upgradeLevel = behaviour.getUpgradeLevel(upgradable, upgrade);
            if (upgradeLevel <= 0) continue;
            behaviour.applyUpgrade(upgradable, upgrade, upgradeLevel, event);
        }
    }

    public static class Upgrade {
        private String id;
        private int tier;
        private Set<BlockConfig> upgradableInfo;

        private Upgrade(String id, int tier) {
            this.id = id;
            this.tier = tier;
            this.upgradableInfo = Sets.newTreeSet();
        }

        public String getId() {
            return this.id;
        }

        public int getTier() {
            return this.tier;
        }

        public void addUpgradableInfo(BlockConfig upgradableInfo) {
            this.upgradableInfo.add(upgradableInfo);
        }

        public Set<BlockConfig> getUpgradables() {
            return this.upgradableInfo;
        }
    }

    public static class UpgradeEventType {
        private UpgradeEventType() {
        }
    }
}

