/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;

public class RenderBlockEntityEntangledChalice
implements BlockEntityRenderer<BlockEntityEntangledChalice> {
    public RenderBlockEntityEntangledChalice(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityEntangledChalice tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlayIn) {
        if (tile != null && !tile.getTank().getFluid().isEmpty() && tile.getTank().getFluid().getFluid() != null) {
            try {
                FluidStack fluid = tile.getTank().getFluid();
                RenderHelpers.renderFluidContext((FluidStack)tile.getTank().getFluid(), (PoseStack)matrixStack, () -> {
                    float height = Math.min(0.95f, (float)fluid.getAmount() / (float)tile.getTank().getCapacity()) * 0.1875f + 0.8125f;
                    int brightness = Math.max(combinedLight, fluid.getFluid().getAttributes().getLuminosity(fluid));
                    int l2 = brightness >> 16 & 0xFFFF;
                    int i3 = brightness & 0xFFFF;
                    TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
                    Triple color = Helpers.intToRGB((int)fluid.getFluid().getAttributes().getColor((BlockAndTintGetter)tile.m_58904_(), tile.m_58899_()));
                    VertexConsumer vb = renderTypeBuffer.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_118414_().m_118330_()));
                    Matrix4f matrix = matrixStack.m_85850_().m_85861_();
                    vb.m_85982_(matrix, 0.1875f, height, 0.1875f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
                    vb.m_85982_(matrix, 0.1875f, height, 0.8125f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                    vb.m_85982_(matrix, 0.8125f, height, 0.8125f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                    vb.m_85982_(matrix, 0.8125f, height, 0.1875f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
                });
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

