/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierActionRegistry;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;

public class BlockEntityPurifier
extends BlockEntityTankInventory {
    public static final int SLOTS = 2;
    public static final int SLOT_PURIFY = 0;
    public static final int SLOT_ADDITIONAL = 1;
    private static final int ANIMATION_FINISHED_DURATION = 2;
    @NBTPersist
    private Float randomRotation = Float.valueOf(0.0f);
    private int tick = 0;
    public static final int MAX_BUCKETS = 3;
    @NBTPersist
    public Integer tickCount = 0;
    @NBTPersist
    public Float additionalRotation2 = Float.valueOf(0.0f);
    @NBTPersist
    public Float additionalRotationPrev = Float.valueOf(0.0f);
    @NBTPersist
    public Float additionalRotation = Float.valueOf(0.0f);
    @NBTPersist
    private Integer finishedAnimation = 0;
    @NBTPersist
    private Integer currentAction = -1;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;

    public BlockEntityPurifier(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_PURIFIER, blockPos, blockState, 2, 1, 3000, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.getInventory().addDirtyMarkListener(() -> ((BlockEntityPurifier)this).sendUpdate());
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int i, ItemStack itemStack) {
                if (i == 0) {
                    return itemStack.m_41613_() == 1 && BlockEntityPurifier.this.getActions().isItemValidForMainSlot(itemStack);
                }
                if (i == 1) {
                    return itemStack.m_41613_() == 1 && BlockEntityPurifier.this.getActions().isItemValidForAdditionalSlot(itemStack);
                }
                return false;
            }
        };
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    public IPurifierActionRegistry getActions() {
        return (IPurifierActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IPurifierActionRegistry.class);
    }

    public void onActionFinished() {
        this.finishedAnimation = 2;
    }

    public int getBucketsFloored() {
        return (int)Math.floor((double)this.getTank().getFluidAmount() / 1000.0);
    }

    public int getBucketsRest() {
        return this.getTank().getFluidAmount() % 1000;
    }

    public void setBuckets(int buckets, int rest) {
        this.getTank().setFluid(new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, 1000 * buckets + rest));
        this.sendUpdate();
    }

    public int getMaxBuckets() {
        return 3;
    }

    private void updateAdditionalItem() {
        float f2;
        float baseNextRotation;
        this.additionalRotationPrev = this.additionalRotation2;
        this.additionalRotation = Float.valueOf(this.additionalRotation.floatValue() + 0.02f);
        while (this.additionalRotation2.floatValue() >= (float)Math.PI) {
            this.additionalRotation2 = Float.valueOf(this.additionalRotation2.floatValue() - (float)Math.PI * 2);
        }
        while (this.additionalRotation2.floatValue() < (float)(-Math.PI)) {
            this.additionalRotation2 = Float.valueOf(this.additionalRotation2.floatValue() + (float)Math.PI * 2);
        }
        while (this.additionalRotation.floatValue() >= (float)Math.PI) {
            this.additionalRotation = Float.valueOf(this.additionalRotation.floatValue() - (float)Math.PI * 2);
        }
        while (this.additionalRotation.floatValue() < (float)(-Math.PI)) {
            this.additionalRotation = Float.valueOf(this.additionalRotation.floatValue() + (float)Math.PI * 2);
        }
        for (baseNextRotation = this.additionalRotation.floatValue() - this.additionalRotation2.floatValue(); baseNextRotation >= (float)Math.PI; baseNextRotation -= (float)Math.PI * 2) {
        }
        while (baseNextRotation < (float)(-Math.PI)) {
            baseNextRotation += (float)Math.PI * 2;
        }
        this.additionalRotation2 = Float.valueOf(this.additionalRotation2.floatValue() + baseNextRotation * 0.4f);
        this.tickCount = this.tickCount + 1;
        for (f2 = this.tRot - this.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.rot += f2 * 0.4f;
        this.open = Mth.m_14036_((float)this.open, (float)0.0f, (float)1.0f);
        ++this.time;
        this.oFlip = this.flip;
        float f = (this.flipT - this.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }

    public ItemStack getPurifyItem() {
        return this.getInventory().m_8020_(0);
    }

    public void setPurifyItem(ItemStack itemStack) {
        this.randomRotation = Float.valueOf(this.f_58857_.f_46441_.nextFloat() * 360.0f);
        this.getInventory().m_6836_(0, itemStack);
    }

    public ItemStack getAdditionalItem() {
        return this.getInventory().m_8020_(1);
    }

    public void setAdditionalItem(ItemStack itemStack) {
        this.getInventory().m_6836_(1, itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showEffect() {
        for (int i = 0; i < 1; ++i) {
            double particleX = (double)this.m_58899_().m_123341_() + 0.2 + this.f_58857_.f_46441_.nextDouble() * 0.6;
            double particleY = (double)this.m_58899_().m_123342_() + 0.2 + this.f_58857_.f_46441_.nextDouble() * 0.6;
            double particleZ = (double)this.m_58899_().m_123343_() + 0.2 + this.f_58857_.f_46441_.nextDouble() * 0.6;
            float particleMotionX = -0.01f + this.f_58857_.f_46441_.nextFloat() * 0.02f;
            float particleMotionY = 0.01f;
            float particleMotionZ = -0.01f + this.f_58857_.f_46441_.nextFloat() * 0.02f;
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)RegistryEntries.PARTICLE_BLOOD_BUBBLE, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showEnchantingEffect() {
        if (this.f_58857_.f_46441_.nextInt(10) == 0) {
            for (int i = 0; i < 1; ++i) {
                double particleX = (double)this.m_58899_().m_123341_() + 0.45 + this.f_58857_.f_46441_.nextDouble() * 0.1;
                double particleY = (double)this.m_58899_().m_123342_() + 1.45 + this.f_58857_.f_46441_.nextDouble() * 0.1;
                double particleZ = (double)this.m_58899_().m_123343_() + 0.45 + this.f_58857_.f_46441_.nextDouble() * 0.1;
                float particleMotionX = -0.4f + this.f_58857_.f_46441_.nextFloat() * 0.8f;
                float particleMotionY = -this.f_58857_.f_46441_.nextFloat();
                float particleMotionZ = -0.4f + this.f_58857_.f_46441_.nextFloat() * 0.8f;
                Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)ParticleTypes.f_123809_, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showEnchantedEffect() {
        for (int i = 0; i < 100; ++i) {
            double particleX = (double)this.m_58899_().m_123341_() + 0.45 + this.f_58857_.f_46441_.nextDouble() * 0.1;
            double particleY = (double)this.m_58899_().m_123342_() + 1.45 + this.f_58857_.f_46441_.nextDouble() * 0.1;
            double particleZ = (double)this.m_58899_().m_123343_() + 0.45 + this.f_58857_.f_46441_.nextDouble() * 0.1;
            float particleMotionX = -0.4f + this.f_58857_.f_46441_.nextFloat() * 0.8f;
            float particleMotionY = -0.4f + this.f_58857_.f_46441_.nextFloat() * 0.8f;
            float particleMotionZ = -0.4f + this.f_58857_.f_46441_.nextFloat() * 0.8f;
            Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)RegistryEntries.PARTICLE_MAGIC_FINISH, false, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public float getRandomRotation() {
        return this.randomRotation.floatValue();
    }

    @Override
    public void onTankChanged() {
        super.onTankChanged();
        this.sendUpdate();
    }

    public int getTick() {
        return this.tick;
    }

    public Integer getCurrentAction() {
        return this.currentAction;
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityPurifier> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityPurifier blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            int actionId = blockEntity.currentAction;
            if (actionId < 0) {
                actionId = blockEntity.getActions().canWork(blockEntity);
            }
            if (actionId >= 0) {
                ++blockEntity.tick;
                if (blockEntity.getActions().work(actionId, blockEntity)) {
                    blockEntity.tick = 0;
                    blockEntity.currentAction = -1;
                    blockEntity.onActionFinished();
                }
            } else {
                blockEntity.tick = 0;
                blockEntity.currentAction = -1;
            }
            if (blockEntity.finishedAnimation > 0) {
                BlockEntityPurifier blockEntityPurifier = blockEntity;
                Integer n = blockEntityPurifier.finishedAnimation;
                blockEntityPurifier.finishedAnimation = blockEntityPurifier.finishedAnimation - 1;
                if (level.m_5776_()) {
                    blockEntity.showEnchantedEffect();
                }
            }
            blockEntity.updateAdditionalItem();
        }
    }
}

