/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.fluid.WorldSharedTank;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class BlockEntityEntangledChalice
extends CyclopsBlockEntity {
    public static final int BASE_CAPACITY = 4000;
    private final WorldSharedTank tank = new WorldSharedTank(4000);

    public BlockEntityEntangledChalice(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_ENTANGLED_CHALICE, blockPos, blockState);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(this::getTank));
    }

    public WorldSharedTank getTank() {
        return this.tank;
    }

    public double getFillRatio() {
        int prev = this.getTank().getPreviousAmount();
        float alpha = (float)WorldSharedTankCache.getInstance().getTickOffset() / 10.0f;
        double interpolatedAmount = (float)prev * (1.0f - alpha) + (float)this.getTank().getFluidAmount() * alpha;
        return Math.min(1.0, interpolatedAmount / (double)this.getTank().getCapacity());
    }

    public String getWorldTankId() {
        return this.getTank().getTankID();
    }

    public void setWorldTankId(String tankId) {
        this.getTank().setTankID(tankId);
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.tank.readFromNBT(tag, "tank");
    }

    public void m_183515_(CompoundTag tag) {
        this.tank.writeToNBT(tag, "tank");
        super.m_183515_(tag);
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityEntangledChalice> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEntangledChalice blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            blockEntity.getTank().resetPreviousFluid();
        }
    }
}

