/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodChest;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.RepairItemTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.inventory.container.ContainerBloodChest;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;

public class BlockEntityBloodChest
extends BlockEntityTickingTankInventory<BlockEntityBloodChest>
implements MenuProvider,
LidBlockEntity {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 10;
    public static final int SLOTS = 11;
    public static final int SLOT_CONTAINER = 10;
    public static final int LIQUID_PER_SLOT = 10000;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityBloodChest.playSound(level, pos, blockState, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityBloodChest.playSound(level, pos, blockState, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityBloodChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ContainerBloodChest)) {
                return false;
            }
            Container container = ((ContainerBloodChest)player.f_36096_).getContainerInventory();
            return container == BlockEntityBloodChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private static final Map<Class<?>, ITickAction<BlockEntityBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<BlockEntityBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;

    public BlockEntityBloodChest(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_BLOOD_CHEST, blockPos, blockState, 11, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        for (int i = 0; i < 10; ++i) {
            this.addTicker(new TickComponent<BlockEntityBloodChest, ITickAction<BlockEntityBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<BlockEntityBloodChest, ITickAction<BlockEntityBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 10, false, true));
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerChest = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), IntStream.range(0, 10).toArray()));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{10}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerChest);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerChest);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    public Direction getRotation() {
        if (this.m_58904_() == null) {
            return Direction.SOUTH;
        }
        return ((Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.m_58900_(), (Property)BlockBloodChest.FACING, (Comparable)Direction.SOUTH)).m_122424_();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int slot, ItemStack itemstack) {
                if (slot == 10) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemstack, (Fluid)RegistryEntries.FLUID_BLOOD);
                }
                if (slot <= 10 && slot >= 0) {
                    return SlotRepairable.checkIsItemValid(itemstack);
                }
                return false;
            }

            public void m_5856_(Player entityPlayer) {
                super.m_5856_(entityPlayer);
                BlockEntityBloodChest.this.startOpen(entityPlayer);
            }

            public void m_5785_(Player entityPlayer) {
                super.m_5785_(entityPlayer);
                BlockEntityBloodChest.this.stopOpen(entityPlayer);
            }

            public boolean m_6542_(Player entityPlayer) {
                return super.m_6542_(entityPlayer) && BlockEntityBloodChest.this.f_58857_ != null && BlockEntityBloodChest.this.f_58857_.m_7702_(BlockEntityBloodChest.this.m_58899_()) == BlockEntityBloodChest.this;
            }
        };
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent) {
        level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    public boolean m_7531_(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.m_155377_(value > 0);
            return true;
        }
        return super.m_7531_(eventType, value);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.m_60734_();
        level.m_7696_(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityBloodChest blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public float m_6683_(float value) {
        return this.chestLidController.m_155375_(value);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerBloodChest(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.evilcraft.blood_chest");
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new RepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
    }

    public static class TickerClient
    extends BlockEntityTickingTankInventory.TickerClient<BlockEntityBloodChest> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityBloodChest blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            BlockEntityBloodChest.lidAnimateTick(level, pos, blockState, blockEntity);
        }
    }
}

