/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.block.BlockBloodStainConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodStain;
import org.cyclops.evilcraft.client.particle.ParticleBloodSplash;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class BlockBloodStain
extends BlockWithEntity {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockBloodStain(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityBloodStain::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    public boolean m_5946_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (!BlockBloodStainConfig.spawnOnBlockEntities && worldIn.m_7702_(blockpos) != null) {
            return false;
        }
        String blockName = blockstate.m_60734_().getRegistryName().toString();
        for (String blacklistedRegex : BlockBloodStainConfig.spawnBlacklist) {
            if (!blockName.matches(blacklistedRegex)) continue;
            return false;
        }
        return blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) && blockstate.isValidSpawn(worldIn, blockpos, SpawnPlacements.Type.ON_GROUND, EntityType.f_20555_) || blockstate.m_60734_() == Blocks.f_50332_;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_ && !state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_7471_(pos, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        BlockBloodStain.splash(worldIn, pos);
        super.m_6256_(state, worldIn, pos, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.m_20184_().m_82553_() > 0.1) {
            BlockBloodStain.splash(worldIn, pos);
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void splash(Level world, BlockPos blockPos) {
        if (MinecraftHelpers.isClientSide()) {
            ParticleBloodSplash.spawnParticles(world, blockPos, 1, 1 + world.f_46441_.nextInt(1));
        }
    }

    public void m_141997_(BlockState blockState, Level world, BlockPos blockPos, Biome.Precipitation precipitation) {
        world.m_7471_(blockPos, false);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void bloodStainedBlockEvent(LivingDeathEvent event) {
        if (event.getSource() == DamageSource.f_19315_ && !(event.getEntity() instanceof EntityVengeanceSpirit)) {
            int x = Mth.m_14107_((double)event.getEntity().m_20185_());
            int y = Mth.m_14107_((double)event.getEntity().m_20186_());
            int z = Mth.m_14107_((double)event.getEntity().m_20189_());
            if (!event.getEntity().f_19853_.m_5776_()) {
                event.getEntity().m_20194_().execute(() -> {
                    BlockPos pos = new BlockPos(x, y - 1, z);
                    Block block = event.getEntity().f_19853_.m_8055_(pos).m_60734_();
                    int amount = (int)((float)BlockBloodStainConfig.bloodMBPerHP * event.getEntityLiving().m_21233_());
                    if (block != this) {
                        pos = pos.m_142082_(0, 1, 0);
                        if (event.getEntity().m_20193_().m_46859_(pos) && this.m_7898_(this.m_49966_(), (LevelReader)event.getEntity().m_20193_(), pos)) {
                            event.getEntity().m_20193_().m_46597_(pos, this.m_49966_());
                        }
                    }
                    BlockEntityHelpers.get((BlockGetter)event.getEntity().m_20193_(), (BlockPos)pos, BlockEntityBloodStain.class).ifPresent(tile -> tile.addAmount(amount));
                });
            } else {
                Random random = new Random();
                BlockPos pos = new BlockPos(x, y, z);
                ParticleBloodSplash.spawnParticles(event.getEntity().f_19853_, pos.m_142082_(0, 1, 0), (int)event.getEntityLiving().m_21233_() + random.nextInt(15), 5 + random.nextInt(5));
            }
        }
    }
}

