/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.api.broom;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.IBroomModifierRegistry;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.broom.PotionEffectBroomCollision;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.item.ItemBroomConfig;
import org.cyclops.evilcraft.item.ItemMaceOfDistortion;

public class BroomModifiers {
    public static final IBroomModifierRegistry REGISTRY = (IBroomModifierRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBroomModifierRegistry.class);
    public static BroomModifier MODIFIER_COUNT;
    public static BroomModifier SPEED;
    public static BroomModifier ACCELERATION;
    public static BroomModifier MANEUVERABILITY;
    public static BroomModifier LEVITATION;
    public static BroomModifier DAMAGE;
    public static BroomModifier PARTICLES;
    public static BroomModifier FLAME;
    public static BroomModifier SMASH;
    public static BroomModifier BOUNCY;
    public static BroomModifier WITHERER;
    public static BroomModifier HUNGERER;
    public static BroomModifier KAMIKAZE;
    public static BroomModifier WITHERSHIELD;
    public static BroomModifier STURDYNESS;
    public static BroomModifier EFFICIENCY;
    public static BroomModifier SWIMMING;
    public static BroomModifier ICY;
    public static BroomModifier STICKY;

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, EventPriority.LOWEST, BroomModifiers::afterItemsRegistered);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Potion.class, EventPriority.HIGHEST, BroomModifiers::afterAfterItemsRegistered);
        MinecraftForge.EVENT_BUS.addListener(BroomModifiers::onTagsUpdated);
        MinecraftForge.EVENT_BUS.addListener(BroomModifiers::onLivingHurt);
    }

    public static void afterItemsRegistered(RegistryEvent<Item> event) {
        BroomParts.loadPre();
        BroomModifiers.loadPre();
    }

    public static void afterAfterItemsRegistered(RegistryEvent<Potion> event) {
        BroomParts.loadPost();
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        BroomModifiers.loadPost();
    }

    protected static void loadPre() {
        MODIFIER_COUNT = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "modifier_count"), BroomModifier.Type.ADDITIVE, 0.0f, 1.0f, 3, true, ChatFormatting.BOLD, Helpers.RGBToInt((int)0, (int)0, (int)0)));
        REGISTRY.overrideDefaultModifierPart(MODIFIER_COUNT, null);
        SPEED = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "speed"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.RED, Helpers.RGBToInt((int)230, (int)20, (int)20)));
        ACCELERATION = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "acceleration"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.DARK_GRAY, Helpers.RGBToInt((int)20, (int)20, (int)20)));
        MANEUVERABILITY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "maneuverability"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.YELLOW, Helpers.RGBToInt((int)160, (int)160, (int)20)));
        LEVITATION = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "levitation"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, ChatFormatting.WHITE, Helpers.RGBToInt((int)230, (int)230, (int)230)));
        DAMAGE = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "damage"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, ChatFormatting.GRAY, Helpers.RGBToInt((int)100, (int)100, (int)100)));
        PARTICLES = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "particles"), BroomModifier.Type.ADDITIVE, 0.0f, 50.0f, 1, false, ChatFormatting.LIGHT_PURPLE, Helpers.RGBToInt((int)160, (int)20, (int)160)));
        FLAME = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "flame"), BroomModifier.Type.ADDITIVE, 0.0f, 4.0f, 3, false, ChatFormatting.GOLD, Helpers.RGBToInt((int)100, (int)100, (int)0)));
        SMASH = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "smash"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 2, false, ChatFormatting.AQUA, Helpers.RGBToInt((int)20, (int)60, (int)60)));
        BOUNCY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "bouncy"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.GREEN, Helpers.RGBToInt((int)20, (int)200, (int)60)));
        WITHERER = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "witherer"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_GRAY, Helpers.RGBToInt((int)20, (int)20, (int)20)));
        HUNGERER = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "hungerer"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_GREEN, Helpers.RGBToInt((int)20, (int)120, (int)20)));
        KAMIKAZE = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "kamikaze"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_GREEN, Helpers.RGBToInt((int)20, (int)120, (int)20)));
        WITHERSHIELD = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "withershield"), BroomModifier.Type.ADDITIVE, 0.0f, 5.0f, 4, false, ChatFormatting.DARK_BLUE, Helpers.RGBToInt((int)20, (int)20, (int)120)));
        STURDYNESS = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "sturdyness"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, ChatFormatting.GRAY, Helpers.RGBToInt((int)100, (int)100, (int)100)));
        EFFICIENCY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "efficiency"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.DARK_RED, Helpers.RGBToInt((int)92, (int)29, (int)29)));
        SWIMMING = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "swimming"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, ChatFormatting.AQUA, Helpers.RGBToInt((int)150, (int)150, (int)235)));
        ICY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "icy"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.WHITE, Helpers.RGBToInt((int)220, (int)220, (int)240)));
        STICKY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "sticky"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, ChatFormatting.GOLD, Helpers.RGBToInt((int)78, (int)58, (int)12)));
        DAMAGE.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                float damage = modifierValue * (float)broom.getLastPlayerSpeed() / 50.0f;
                if (damage > 0.0f) {
                    entity.m_6469_((DamageSource)ExtendedDamageSource.broomDamage((LivingEntity)broom.m_6688_()), damage);
                }
            }
        });
        FLAME.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                if (modifierValue > 0.0f) {
                    entity.m_20254_((int)modifierValue);
                }
            }
        });
        SMASH.addTickListener(new BroomModifier.ITickListener(){

            @Override
            public void onTick(EntityBroom broom, float modifierValue) {
                Player player;
                double pitch = (double)(broom.m_146909_() + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(broom.m_146908_() + 90.0f) * Math.PI / 180.0;
                double x = Math.sin(pitch) * Math.cos(yaw);
                double z = Math.sin(pitch) * Math.sin(yaw);
                double y = Math.cos(pitch);
                double r = -0.1;
                BlockPos blockpos = new BlockPos(broom.m_142469_().f_82288_ + x + r, broom.m_142469_().f_82289_ + y + r, broom.m_142469_().f_82290_ + z + r);
                BlockPos blockpos1 = new BlockPos(broom.m_142469_().f_82291_ + x - r, broom.m_142469_().f_82292_ + y - r + 1.0, broom.m_142469_().f_82293_ + z - r);
                Level world = broom.f_19853_;
                float maxHardness = modifierValue;
                float toughnessModifier = Math.min(1.0f, 0.5f + broom.getModifier(STURDYNESS) / (STURDYNESS.getMaxTierValue() * 1.5f) / 2.0f);
                LivingEntity ridingEntity = broom.m_6688_() instanceof LivingEntity ? (LivingEntity)broom.m_6688_() : null;
                Player player2 = player = broom.m_6688_() instanceof Player ? (Player)broom.m_6688_() : null;
                if (world.m_46832_(blockpos, blockpos1)) {
                    for (int i = blockpos.m_123341_(); i <= blockpos1.m_123341_(); ++i) {
                        for (int j = blockpos.m_123342_(); j <= blockpos1.m_123342_(); ++j) {
                            for (int k = blockpos.m_123343_(); k <= blockpos1.m_123343_(); ++k) {
                                float hardness;
                                BlockPos pos = new BlockPos(i, j, k);
                                BlockState blockState = world.m_8055_(pos);
                                FluidState fluidState = world.m_6425_(pos);
                                Block block = blockState.m_60734_();
                                if (world.m_46859_(pos) || !broom.canConsume(ItemBroomConfig.bloodUsageBlockBreak, ridingEntity) || !((hardness = blockState.m_60800_((BlockGetter)world, pos)) > 0.0f) || !(hardness <= maxHardness)) continue;
                                broom.consume(ItemBroomConfig.bloodUsageBlockBreak, ridingEntity);
                                if (player == null) {
                                    world.m_46961_(pos, true);
                                } else if (!broom.f_19853_.m_5776_()) {
                                    ServerPlayer playerMp = (ServerPlayer)player;
                                    int expToDrop = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)playerMp.f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
                                    if (expToDrop >= 0) {
                                        block.m_5707_(world, pos, blockState, player);
                                        if (block.onDestroyedByPlayer(blockState, world, pos, player, true, fluidState)) {
                                            block.m_6786_((LevelAccessor)world, pos, blockState);
                                            block.m_6240_(world, player, pos, blockState, world.m_7702_(pos), ItemStack.f_41583_);
                                            block.m_49805_((ServerLevel)world, pos, expToDrop);
                                        }
                                        playerMp.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
                                    }
                                } else if (Minecraft.m_91087_().f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                                    world.m_6798_(2001, pos, Block.m_49956_((BlockState)blockState));
                                    if (block.onDestroyedByPlayer(blockState, world, pos, player, true, fluidState)) {
                                        block.m_6786_((LevelAccessor)world, pos, blockState);
                                    }
                                    Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, ((BlockHitResult)Minecraft.m_91087_().f_91077_).m_82434_()));
                                }
                                broom.setLastPlayerSpeed(broom.getLastPlayerSpeed() * (double)toughnessModifier);
                            }
                        }
                    }
                }
            }
        });
        BOUNCY.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                double dz;
                double dy;
                double dx;
                double d;
                float power = modifierValue * (float)broom.getLastPlayerSpeed() / 20.0f;
                if (power > 0.0f && (d = (double)Mth.m_14116_((float)((float)((dx = entity.m_20185_() - broom.m_20185_()) * dx + (dy = entity.m_20186_() + (double)entity.m_20192_() - broom.m_20186_()) * dy + (dz = entity.m_20189_() - broom.m_20189_()) * dz)))) != 0.0) {
                    entity.m_20256_(entity.m_20184_().m_82520_(dx /= d, dy /= d, dz /= d).m_82542_((double)power, (double)power, (double)power));
                    if (broom.f_19853_.m_5776_()) {
                        ItemMaceOfDistortion.showEntityDistored(broom.f_19853_, null, entity, (int)(power / 10.0f));
                    }
                }
            }
        });
        WITHERER.addCollisionListener(new PotionEffectBroomCollision(MobEffects.f_19615_));
        HUNGERER.addCollisionListener(new PotionEffectBroomCollision(MobEffects.f_19612_));
        KAMIKAZE.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                Level world = broom.f_19853_;
                float power = modifierValue * (float)broom.getLastPlayerSpeed() / 5.0f;
                if (power > 0.0f && broom.m_6688_() != null) {
                    broom.m_8127_();
                    world.m_46511_(null, broom.m_20185_(), broom.m_20186_(), broom.m_20189_(), power, Explosion.BlockInteraction.DESTROY);
                }
            }
        });
        ICY.addCollisionListener(new PotionEffectBroomCollision(MobEffects.f_19597_, 2));
        STICKY.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                if (!entity.f_19853_.m_5776_() && !entity.m_20159_() && entity.m_7341_((Entity)broom)) {
                    entity.m_20329_((Entity)broom);
                }
            }
        });
    }

    protected static void loadPost() {
        REGISTRY.clearModifierItems();
        REGISTRY.registerModifiersItem(MODIFIER_COUNT, 1.0f, new ItemStack((ItemLike)Items.f_42686_));
        REGISTRY.registerModifiersItem(MODIFIER_COUNT, 1.0f, new ItemStack((ItemLike)RegistryEntries.ITEM_GARMONBOZIA));
        REGISTRY.registerModifiersItem(SPEED, 1.0f, new ItemStack((ItemLike)Items.f_42451_));
        REGISTRY.registerModifiersItem(SPEED, 9.0f, new ItemStack((ItemLike)Blocks.f_50330_));
        REGISTRY.registerModifiersItem(ACCELERATION, 1.0f, new ItemStack((ItemLike)Items.f_42413_));
        REGISTRY.registerModifiersItem(ACCELERATION, 9.0f, new ItemStack((ItemLike)Blocks.f_50353_));
        REGISTRY.registerModifiersItem(MANEUVERABILITY, 2.0f, new ItemStack((ItemLike)Items.f_42525_));
        REGISTRY.registerModifiersItem(MANEUVERABILITY, 8.0f, new ItemStack((ItemLike)Blocks.f_50141_));
        REGISTRY.registerModifiersItem(LEVITATION, 1.0f, new ItemStack((ItemLike)Items.f_42402_));
        REGISTRY.registerModifiersItem(LEVITATION, 50.0f, new ItemStack((ItemLike)Items.f_42714_));
        REGISTRY.registerModifiersItem(DAMAGE, 2.0f, new ItemStack((ItemLike)RegistryEntries.ITEM_DARK_SPIKE));
        REGISTRY.registerModifiersItem(DAMAGE, 1.0f, new ItemStack((ItemLike)Items.f_42692_));
        REGISTRY.registerModifiersItem(PARTICLES, 1.0f, new ItemStack((ItemLike)Items.f_42403_));
        REGISTRY.registerModifiersItem(FLAME, 1.0f, new ItemStack((ItemLike)Items.f_42593_));
        REGISTRY.registerModifiersItem(SMASH, 1.0f, new ItemStack((ItemLike)Items.f_42385_));
        REGISTRY.registerModifiersItem(SMASH, 5.0f, new ItemStack((ItemLike)Items.f_42390_));
        REGISTRY.registerModifiersItem(BOUNCY, 1.0f, new ItemStack((ItemLike)Items.f_42518_));
        REGISTRY.registerModifiersItem(BOUNCY, 9.0f, new ItemStack((ItemLike)Blocks.f_50374_));
        BroomModifiers.registerModifierTagItem(STURDYNESS, 1.0f, new ResourceLocation("forge", "stone"));
        REGISTRY.registerModifiersItem(STURDYNESS, 10.0f, new ItemStack((ItemLike)Blocks.f_50080_));
        BroomModifiers.registerModifierTagItem(EFFICIENCY, 1.0f, new ResourceLocation("evilcraft", "gems/dark_power"));
        REGISTRY.registerModifiersItem(SWIMMING, 1.0f, new ItemStack((ItemLike)Items.f_42695_));
        REGISTRY.registerModifiersItem(SWIMMING, 4.0f, new ItemStack((ItemLike)Blocks.f_50377_));
        REGISTRY.registerModifiersItem(SWIMMING, 9.0f, new ItemStack((ItemLike)Blocks.f_50379_));
        REGISTRY.registerModifiersItem(SWIMMING, 20.0f, new ItemStack((ItemLike)Items.f_42715_));
        REGISTRY.registerModifiersItem(SWIMMING, 25.0f, new ItemStack((ItemLike)Items.f_42354_));
        REGISTRY.registerModifiersItem(ICY, 1.0f, new ItemStack((ItemLike)Blocks.f_50126_));
        REGISTRY.registerModifiersItem(ICY, 5.0f, new ItemStack((ItemLike)Blocks.f_50354_));
        REGISTRY.registerModifiersItem(ICY, 10.0f, new ItemStack((ItemLike)Blocks.f_50568_));
        REGISTRY.registerModifiersItem(STICKY, 1.0f, new ItemStack((ItemLike)Items.f_41867_));
        REGISTRY.registerModifiersItem(STICKY, 2.0f, new ItemStack((ItemLike)Items.f_41910_));
        REGISTRY.registerModifiersItem(STICKY, 4.0f, new ItemStack((ItemLike)Items.f_42787_));
        REGISTRY.registerModifiersItem(STICKY, 16.0f, new ItemStack((ItemLike)Items.f_42788_));
        EvilCraft.clog(String.format("%s Broom modifiers can be applied!", REGISTRY.getModifiers().size()));
    }

    public static void onLivingHurt(LivingHurtEvent event) {
        EntityBroom broom;
        float modifierValue;
        if (event.getEntityLiving() != null && event.getEntityLiving().m_20202_() instanceof EntityBroom && event.getSource().m_7640_() instanceof Projectile && (modifierValue = (broom = (EntityBroom)event.getEntityLiving().m_20202_()).getModifier(WITHERSHIELD)) > 0.0f && modifierValue > (float)broom.f_19853_.f_46441_.nextInt((int)WITHERSHIELD.getMaxTierValue())) {
            event.setCanceled(true);
        }
    }

    public static void registerModifierTagItem(BroomModifier modifier, float value, ResourceLocation name) {
        ITag tag = ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)name));
        if (!tag.isEmpty()) {
            for (Item item : tag) {
                REGISTRY.registerModifiersItem(modifier, value, new ItemStack((ItemLike)item));
            }
        } else {
            EvilCraft.clog(String.format("Broom modifiers could not find a tag instance for %s", name), org.apache.logging.log4j.Level.WARN);
        }
    }
}

