/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.registry.SGBlocks;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.network.NetworkEvent;

public class UpdateDataHandlerPacket {
    protected final byte mode;
    protected final BlockPos pos;
    protected final ResourceLocation type;
    protected final Map<String, String> dataMap;

    public UpdateDataHandlerPacket(byte mode, BlockPos pos, ResourceLocation type, Map<String, String> dataMap) {
        this.mode = mode;
        this.pos = pos;
        this.type = type;
        this.dataMap = dataMap;
    }

    public static void encoder(UpdateDataHandlerPacket packet, FriendlyByteBuf buff) {
        buff.writeByte((int)packet.mode);
        buff.m_130064_(packet.pos);
        buff.m_130085_(packet.type);
        buff.m_178355_(packet.dataMap, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130070_);
    }

    public static UpdateDataHandlerPacket decoder(FriendlyByteBuf buff) {
        try {
            byte mode = buff.readByte();
            BlockPos pos = buff.m_130135_();
            ResourceLocation type = buff.m_130281_();
            Map dataMap = buff.m_178368_(FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130277_);
            return new UpdateDataHandlerPacket(mode, pos, type, dataMap);
        }
        catch (Throwable t) {
            return new UpdateDataHandlerPacket(0, BlockPos.f_121853_, PacketHandler.ERRORED, Collections.emptyMap());
        }
    }

    public static void handler(UpdateDataHandlerPacket packet, Supplier<NetworkEvent.Context> context) {
        if (packet.type.equals((Object)PacketHandler.ERRORED) && packet.pos.equals((Object)BlockPos.f_121853_)) {
            ServerPlayer sender = context.get().getSender();
            StructureGelMod.logWarn("An invalid packet ({}) was sent to the server from {} at {} in {}", packet.getClass().getSimpleName(), sender.m_36316_().getName(), sender.m_142538_(), sender.f_19853_.m_46472_().m_135782_());
            return;
        }
        context.get().enqueueWork(() -> {
            ServerLevel level = ((NetworkEvent.Context)context.get()).getSender().m_183503_();
            BlockPos pos = packet.pos;
            BlockEntity blockEntity = level.m_7702_(pos);
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() == SGBlocks.DATA_HANDLER.get() && blockEntity instanceof DataHandlerBlockEntity) {
                DataHandlerBlockEntity dataHandler = (DataHandlerBlockEntity)blockEntity;
                dataHandler.setDataHandlerType(packet.type);
                dataHandler.setDataEntries(packet.dataMap);
                blockEntity.m_6596_();
                level.m_7260_(pos, state, state, 3);
                if (packet.mode == 1) {
                    ItemEntity itemEntity;
                    ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                    ItemStack stack = new ItemStack((ItemLike)SGBlocks.DATA_HANDLER.get());
                    blockEntity.m_187476_(stack);
                    boolean hasItem = false;
                    for (ItemStack invStack : player.m_150109_().f_35974_) {
                        if (!invStack.equals(stack, true)) continue;
                        hasItem = true;
                        break;
                    }
                    if (!hasItem && (itemEntity = player.m_36176_(stack, false)) != null) {
                        itemEntity.m_32061_();
                        itemEntity.m_32047_(player.m_142081_());
                    }
                    int offsetAmt = 8;
                    BoundingBox bounds = BoundingBox.m_162375_((Vec3i)pos.m_142082_(-offsetAmt, -offsetAmt, -offsetAmt), (Vec3i)pos.m_142082_(offsetAmt, offsetAmt, offsetAmt));
                    DataHandlerBlockEntity.handle(state, packet.type, packet.dataMap, pos, (WorldGenLevel)level, level.f_46441_, bounds, new DummyPiece(bounds), true);
                }
            } else {
                StructureGelMod.logWarn("Attempted to set DataHandlerBlockEntity data for the wrong block.", new Object[0]);
            }
        });
        context.get().setPacketHandled(true);
    }

    private static final class DummyPiece
    extends StructurePiece {
        protected DummyPiece(BoundingBox bounds) {
            super(StructurePieceType.f_210125_, 0, bounds);
            this.m_73519_(Direction.NORTH);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        }

        public void m_183269_(WorldGenLevel level, StructureFeatureManager structureManager, ChunkGenerator chunkGen, Random rand, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
        }
    }
}

