/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class ToolModeProperty<T> {
    public static final NumberProp<Double> INTEGRITY = ToolModeProperty.doubleProperty("integrity", 0.0, 1.0, 1.0);
    public static final NumberProp<Integer> RADIUS = ToolModeProperty.intProperty("radius", 0, 100, 4);
    public static final NumberProp<Integer> MOVE_DISTANCE = ToolModeProperty.intProperty("move_distance", 1, 100, 1);
    public static final SelectionProp<BooleanProperty> RETAIN_STATE = ToolModeProperty.selectionProperty((String)"retain_state", (StringRepresentable)BooleanProperty.TRUE, (StringRepresentable[])BooleanProperty.VALUES);
    public static final SelectionProp<Replace> REPLACE = ToolModeProperty.selectionProperty((String)"replace", (StringRepresentable)Replace.ALL, (StringRepresentable[])Replace.values());
    public static final SelectionProp<Replace> REPLACE_ALL_AIR = ToolModeProperty.selectionProperty((String)"replace", (StringRepresentable)Replace.ALL, (StringRepresentable[])new Replace[]{Replace.ALL, Replace.AIR});
    public static final SelectionProp<SGRotation> ROTATION = ToolModeProperty.selectionProperty((String)"rotation", (StringRepresentable)SGRotation.R_0, (StringRepresentable[])SGRotation.values());
    public static final SelectionProp<SGMirror> MIRROR = ToolModeProperty.selectionProperty((String)"mirror", (StringRepresentable)SGMirror.NONE, (StringRepresentable[])SGMirror.values());
    public static final SelectionProp<BooleanProperty> CUT_TRUE = ToolModeProperty.selectionProperty((String)"cut", (StringRepresentable)BooleanProperty.TRUE, (StringRepresentable[])BooleanProperty.VALUES);
    public static final SelectionProp<BooleanProperty> CUT_FALSE = ToolModeProperty.selectionProperty((String)"cut", (StringRepresentable)BooleanProperty.FALSE, (StringRepresentable[])BooleanProperty.VALUES);
    public static final SelectionProp<FillMode> FILL_MODE = ToolModeProperty.selectionProperty((String)"fill_mode", (StringRepresentable)FillMode.SOLID, (StringRepresentable[])FillMode.values());
    public static final SelectionProp<Shape> SHAPE = ToolModeProperty.selectionProperty((String)"shape", (StringRepresentable)Shape.SPHERE, (StringRepresentable[])Shape.values());
    private final String key;
    protected final Function<String, T> readFunc;
    protected final Function<T, String> writeFunc;
    protected final Predicate<T> valueTest;
    protected final Supplier<T> defaultVal;
    private final Component nameComponent;
    private final String descKey;

    public ToolModeProperty(String key, Function<String, T> readFunc, Function<T, String> writeFunc, Predicate<T> valueTest, Supplier<T> defaultVal) {
        this.key = key;
        this.readFunc = readFunc;
        this.writeFunc = writeFunc;
        this.valueTest = valueTest;
        this.defaultVal = defaultVal;
        this.nameComponent = new TranslatableComponent("info.structure_gel.building_tool.property." + key);
        this.descKey = "info.structure_gel.building_tool.property." + key + ".description";
    }

    public static NumberProp<Double> doubleProperty(String key, double min, double max, double defaultVal) {
        return new NumberProp<Double>(key, Double.class, Double::valueOf, d -> Double.toString(d), min, max, () -> defaultVal);
    }

    public static NumberProp<Integer> intProperty(String key, int min, int max, int defaultVal) {
        return new NumberProp<Integer>(key, Integer.class, Integer::valueOf, i -> Integer.toString(i), min, max, () -> defaultVal);
    }

    @SafeVarargs
    public static <E extends StringRepresentable> SelectionProp<E> selectionProperty(String key, E defaultValue, E ... values) {
        if (values.length < 1) {
            throw new IllegalArgumentException("Cannot create a ToolModeProperty for an enum without any values. Key = " + key);
        }
        HashMap<String, E> nameMap = new HashMap<String, E>();
        for (E e : values) {
            nameMap.put(e.m_7912_(), e);
        }
        return new SelectionProp<StringRepresentable>(key, nameMap::get, StringRepresentable::m_7912_, nameMap::containsValue, () -> defaultValue, List.of(values));
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultVal.get();
    }

    public T read(String input) {
        try {
            T ret = this.readFunc.apply(input);
            if (ret != null && this.isValid(ret)) {
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.defaultVal.get();
    }

    public String write(T input) {
        return this.writeFunc.apply(input);
    }

    public boolean isValid(T value) {
        return this.valueTest.test(value);
    }

    public Component getNameComponent() {
        return this.nameComponent;
    }

    public String getDescKey() {
        return this.descKey;
    }

    public Component getValueComponent(@Nullable T value) {
        return new TextComponent(value == null ? "null" : value.toString());
    }

    public static class NumberProp<T extends Number>
    extends ToolModeProperty<T> {
        private final T min;
        private final T max;
        private final Class<T> numClass;

        public NumberProp(String key, Class<T> numClass, Function<String, T> readFunc, Function<T, String> writeFunc, T min, T max, Supplier<T> defaultVal) {
            super(key, readFunc, writeFunc, n -> n.doubleValue() >= min.doubleValue() && n.doubleValue() <= max.doubleValue(), defaultVal);
            this.min = min;
            this.max = max;
            this.numClass = numClass;
        }

        @Override
        public T read(String input) {
            try {
                Number ret = (Number)this.readFunc.apply(input);
                if (ret != null) {
                    double d = ret.doubleValue();
                    if (d < ((Number)this.min).doubleValue()) {
                        return this.min;
                    }
                    if (d > ((Number)this.max).doubleValue()) {
                        return this.max;
                    }
                    return (T)ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (T)((Number)this.defaultVal.get());
        }

        public Class<T> getNumberClass() {
            return this.numClass;
        }
    }

    public static class SelectionProp<T extends StringRepresentable>
    extends ToolModeProperty<T> {
        private final List<T> allValues;
        private final Function<T, Component> valueComponents = Util.m_143827_(t -> new TranslatableComponent("info.structure_gel.building_tool.property." + this.getKey() + ".value." + t.m_7912_()));

        private SelectionProp(String key, Function<String, T> readFunc, Function<T, String> writeFunc, Predicate<T> valueTest, Supplier<T> defaultVal, List<T> allValues) {
            super(key, readFunc, writeFunc, valueTest, defaultVal);
            this.allValues = List.copyOf(allValues);
        }

        public List<T> getAllValues() {
            return this.allValues;
        }

        @Override
        public Component getValueComponent(@Nullable T value) {
            if (value == null) {
                return new TextComponent("null");
            }
            return this.valueComponents.apply(value);
        }
    }

    public record BooleanProperty(boolean value, String key) implements StringRepresentable
    {
        private static final BooleanProperty TRUE = new BooleanProperty(true, "true");
        private static final BooleanProperty FALSE = new BooleanProperty(false, "false");
        private static final BooleanProperty[] VALUES = new BooleanProperty[]{TRUE, FALSE};

        public String m_7912_() {
            return this.key;
        }
    }

    public static enum Replace implements StringRepresentable
    {
        ALL("all", (l, s, p) -> true),
        AIR("air", (l, s, p) -> l.m_8055_(p).m_60795_()),
        CLICKED_BLOCK("clicked_block", (l, s, p) -> !s.m_60795_() && l.m_8055_(p).m_60713_(s.m_60734_()));

        private final String key;
        private final ReplaceCondition condition;

        private Replace(String key, ReplaceCondition condition) {
            this.key = key;
            this.condition = condition;
        }

        public ReplaceCondition getCondition() {
            return this.condition;
        }

        public String m_7912_() {
            return this.key;
        }

        public static interface ReplaceCondition {
            public boolean shouldReplace(Level var1, BlockState var2, BlockPos var3);
        }
    }

    public static enum SGRotation implements StringRepresentable
    {
        R_0("r_0", r -> Rotation.NONE),
        R_90("r_90", r -> Rotation.CLOCKWISE_90),
        R_180("r_180", r -> Rotation.CLOCKWISE_180),
        R_270("r_270", r -> Rotation.COUNTERCLOCKWISE_90),
        RANDOM("random", r -> (Rotation)Util.m_137545_((Object[])Rotation.values(), (Random)r));

        private final String key;
        private final Function<Random, Rotation> vanilla;

        private SGRotation(String key, Function<Random, Rotation> vanilla) {
            this.key = key;
            this.vanilla = vanilla;
        }

        public String m_7912_() {
            return this.key;
        }

        public Rotation toVanilla(Random rand) {
            return this.vanilla.apply(rand);
        }
    }

    public static enum SGMirror implements StringRepresentable
    {
        NONE("none", r -> Mirror.NONE),
        Z("z", r -> Mirror.FRONT_BACK),
        X("x", r -> Mirror.LEFT_RIGHT),
        RANDOM("random", r -> (Mirror)Util.m_137545_((Object[])Mirror.values(), (Random)r));

        private final String key;
        private final Function<Random, Mirror> vanilla;

        private SGMirror(String key, Function<Random, Mirror> vanilla) {
            this.key = key;
            this.vanilla = vanilla;
        }

        public String m_7912_() {
            return this.key;
        }

        public Mirror toVanilla(Random rand) {
            return this.vanilla.apply(rand);
        }
    }

    public static enum FillMode implements StringRepresentable
    {
        SOLID("solid"),
        HOLLOW("hollow"),
        FRAME("frame");

        private final String key;

        private FillMode(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }
    }

    public static enum Shape implements StringRepresentable
    {
        CUBE("cube", (vec, r) -> true),
        SPHERE("sphere", (vec, r) -> vec.m_123341_() * vec.m_123341_() + vec.m_123342_() * vec.m_123342_() + vec.m_123343_() * vec.m_123343_() <= r * r),
        DIAMOND("diamond", (vec, r) -> Math.abs(vec.m_123341_()) + Math.abs(vec.m_123342_()) + Math.abs(vec.m_123343_()) <= r);

        private final String key;
        private final BiPredicate<Vec3i, Integer> isInside;

        private Shape(String key, BiPredicate<Vec3i, Integer> isInside) {
            this.key = key;
            this.isInside = isInside;
        }

        public String m_7912_() {
            return this.key;
        }

        public boolean isInside(Vec3i vec, int radius) {
            return this.isInside.test(vec, radius);
        }
    }
}

