/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.asm_hooks;

import com.legacy.structure_gel.api.events.RegisterDimensionEvent;
import com.legacy.structure_gel.api.registry.registrar.DimensionRegistrar;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;

public class LevelStorageSourceHooks {
    private static final String WORLDGENSETTINGS_KEY = "WorldGenSettings";
    private static final String DIMENSIONS_KEY = "dimensions";
    private static final String SEED_KEY = "seed";
    @Nullable
    @Internal
    public static RegistryAccess.Writable registryAccess;

    public static void removeDims(Dynamic<?> dynamic) {
        if (DimensionRegistrar.REGISTRARS.isEmpty()) {
            return;
        }
        boolean removedAny = false;
        StructureGelMod.logDebug("[{}] Removing dimensions to keep the DataFixer from breaking", LevelStorageSourceHooks.class.getSimpleName());
        Object object = dynamic.getValue();
        if (object instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)object;
            if (nbt.m_128425_(WORLDGENSETTINGS_KEY, 10)) {
                CompoundTag wgsNbt = nbt.m_128469_(WORLDGENSETTINGS_KEY);
                if (wgsNbt.m_128425_(DIMENSIONS_KEY, 10)) {
                    CompoundTag dimsNbt = wgsNbt.m_128469_(DIMENSIONS_KEY);
                    for (DimensionRegistrar registrar : DimensionRegistrar.REGISTRARS) {
                        String name = registrar.getDimensionKey().m_135782_().toString();
                        if (!dimsNbt.m_128425_(name, 10)) continue;
                        dimsNbt.m_128473_(name);
                        StructureGelMod.logDebug("Removed {}", name);
                        removedAny = true;
                    }
                } else {
                    StructureGelMod.logError("{} didn't contain \"{}\"", WORLDGENSETTINGS_KEY, DIMENSIONS_KEY);
                }
            } else {
                StructureGelMod.logError("{} didn't contain \"{}\"", "Data", WORLDGENSETTINGS_KEY);
            }
        } else {
            StructureGelMod.logError("Couldn't remove dimensions as the Dynamic passed isn't nbt.", new Object[0]);
        }
        if (!removedAny) {
            StructureGelMod.logDebug("No dimensions were removed", new Object[0]);
        }
    }

    public static void registerDims(Dynamic<?> wgsDynamic) {
        if (DimensionRegistrar.REGISTRARS.isEmpty()) {
            return;
        }
        if (registryAccess != null) {
            StructureGelMod.logDebug("[{}] Registering dimensions", LevelStorageSourceHooks.class.getSimpleName());
            Object object = wgsDynamic.getValue();
            if (object instanceof CompoundTag) {
                CompoundTag wgsNbt = (CompoundTag)object;
                if (wgsNbt.m_128425_(DIMENSIONS_KEY, 10)) {
                    long seed = wgsNbt.m_128454_(SEED_KEY);
                    StructureGelMod.disableLogger();
                    RegisterDimensionEvent registerDimEvent = new RegisterDimensionEvent((Registry<LevelStem>)DimensionType.m_204490_((RegistryAccess)registryAccess, (long)seed), (RegistryAccess)registryAccess, seed);
                    StructureGelMod.enableLogger();
                    CompoundTag dimsNbt = wgsNbt.m_128469_(DIMENSIONS_KEY);
                    for (DimensionRegistrar registrar : DimensionRegistrar.REGISTRARS) {
                        Object t;
                        String name = registrar.getDimensionKey().m_135782_().toString();
                        LevelStem stem = registrar.makeLevelStem(registerDimEvent);
                        Optional op = LevelStem.f_63970_.encodeStart((DynamicOps)RegistryOps.m_206821_((DynamicOps)NbtOps.f_128958_, (RegistryAccess)registryAccess), (Object)stem).result();
                        if (op.isPresent() && (t = op.get()) instanceof CompoundTag) {
                            CompoundTag dimNbt = (CompoundTag)t;
                            dimsNbt.m_128365_(name, (Tag)dimNbt);
                            StructureGelMod.logDebug("Registered dimension: {}", name);
                            continue;
                        }
                        StructureGelMod.logError("Failed to register the dimension {}.", name);
                    }
                } else {
                    StructureGelMod.logError("{} didn't contain \"{}\"", WORLDGENSETTINGS_KEY, DIMENSIONS_KEY);
                }
            } else {
                StructureGelMod.logError("Couldn't register dimensions as the Dynamic passed isn't nbt.", new Object[0]);
            }
        } else {
            StructureGelMod.logError("A value was null and it shouldn't have been. LevelStorageSourceHooks.registryAccess = {}", registryAccess);
        }
        registryAccess = null;
    }
}

