/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.events.RegisterDimensionEvent;
import com.legacy.structure_gel.api.events.WritableRegistryInitEvent;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraftforge.common.MinecraftForge;

public class DimensionRegistrar {
    @Internal
    public static final List<DimensionRegistrar> REGISTRARS = new ArrayList<DimensionRegistrar>();
    private final ResourceKey<LevelStem> dimensionKey;
    private final ResourceKey<DimensionType> dimensionTypeKey;
    private final ResourceKey<NoiseGeneratorSettings> settingsKey;
    private final ResourceKey<Level> levelKey;
    private final Supplier<DimensionType> dimensionTypeSupplier;
    @Nullable
    @Deprecated
    private Holder<DimensionType> dimensionType = null;
    private final Supplier<NoiseGeneratorSettings> noiseSettingsSupplier;
    @Nullable
    @Deprecated
    private Holder<NoiseGeneratorSettings> noiseSettings = null;
    private final Function<RegisterDimensionEvent, ChunkGenerator> chunkGenerator;

    public DimensionRegistrar(ResourceLocation registryName, Supplier<DimensionType> dimensionType, Supplier<NoiseGeneratorSettings> noiseSettings, Function<RegisterDimensionEvent, ChunkGenerator> chunkGenerator) {
        this.dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)registryName);
        this.dimensionTypeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)registryName);
        this.settingsKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)registryName);
        this.levelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)registryName);
        this.dimensionTypeSupplier = dimensionType;
        this.chunkGenerator = chunkGenerator;
        this.noiseSettingsSupplier = noiseSettings;
        if (!BuiltinRegistries.f_123866_.m_142003_(this.settingsKey)) {
            this.noiseSettings = ((WritableRegistry)BuiltinRegistries.f_123866_).m_203505_(this.settingsKey, (Object)this.noiseSettingsSupplier.get(), Lifecycle.stable());
            StructureGelMod.logDebug("Registed {}: {}", "noise generator settings", this.settingsKey.m_135782_());
        }
        MinecraftForge.EVENT_BUS.addListener(this::registerDimensionType);
        MinecraftForge.EVENT_BUS.addListener(this::registerDimension);
        REGISTRARS.add(this);
    }

    public ResourceKey<LevelStem> getDimensionKey() {
        return this.dimensionKey;
    }

    public ResourceKey<DimensionType> getTypeKey() {
        return this.dimensionTypeKey;
    }

    public ResourceKey<NoiseGeneratorSettings> getSettingsKey() {
        return this.settingsKey;
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }

    @Nullable
    @Deprecated(forRemoval=true)
    public Holder<DimensionType> getType() {
        StructureGelMod.logWarn("A MOD USING STRUCTURE GEL IS OUT OF DATE. DimensionRegistrar.getType() may return invalid data and accessing from the actual registry is needed. Dimension: {}", this.dimensionKey.m_135782_());
        return this.dimensionType;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public Holder<NoiseGeneratorSettings> getSettings() {
        StructureGelMod.logWarn("A MOD USING STRUCTURE GEL IS OUT OF DATE. DimensionRegistrar.getSettings() may return invalid data and accessing from the actual registry is needed. Dimension: {}", this.dimensionKey.m_135782_());
        return this.noiseSettings;
    }

    @Deprecated(forRemoval=true)
    public Function<RegisterDimensionEvent, ChunkGenerator> getChunkGenerator() {
        return this.chunkGenerator;
    }

    @Deprecated(forRemoval=true)
    @Internal
    protected final void registerNoiseGeneratorSettings(WritableRegistryInitEvent.RegisterNoiseGeneratorSettings event) {
    }

    @Internal
    protected final void registerDimensionType(WritableRegistryInitEvent.RegisterDimensionType event) {
        this.dimensionType = event.register(this.dimensionTypeKey, this.dimensionTypeSupplier.get());
    }

    @Internal
    protected final void registerDimension(RegisterDimensionEvent event) {
        event.register(this.dimensionKey, this.makeLevelStem(event));
    }

    @Internal
    public final LevelStem makeLevelStem(RegisterDimensionEvent event) {
        return new LevelStem(event.getRegistryAccess().m_175515_(Registry.f_122818_).m_203538_(this.dimensionTypeKey), this.chunkGenerator.apply(event));
    }
}

