/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.datagen.providers.tags.ConventionTags;
import appeng.items.tools.NetworkToolItem;
import appeng.util.LookDirection;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public final class InteractionUtil {
    private InteractionUtil() {
    }

    public static boolean canWrenchDisassemble(ItemStack tool) {
        return tool.m_204117_(ConventionTags.WRENCH);
    }

    public static boolean canWrenchRotate(ItemStack tool) {
        if (tool.m_41720_() instanceof NetworkToolItem) {
            return false;
        }
        return tool.m_204117_(ConventionTags.WRENCH);
    }

    public static boolean isInAlternateUseMode(Player player) {
        return player.m_6144_();
    }

    public static float getEyeOffset(Player player) {
        assert (player.f_19853_.f_46443_) : "Valid only on client";
        return (float)(player.m_20186_() + (double)player.m_20192_() - (double)1.62f);
    }

    public static LookDirection getPlayerRay(Player playerIn) {
        double reachDistance = playerIn.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        return InteractionUtil.getPlayerRay(playerIn, reachDistance);
    }

    public static LookDirection getPlayerRay(Player playerIn, double reachDistance) {
        double x = playerIn.f_19854_ + (playerIn.m_20185_() - playerIn.f_19854_);
        double y = playerIn.f_19855_ + (playerIn.m_20186_() - playerIn.f_19855_) + (double)playerIn.m_20192_();
        double z = playerIn.f_19856_ + (playerIn.m_20189_() - playerIn.f_19856_);
        float playerPitch = playerIn.f_19860_ + (playerIn.m_146909_() - playerIn.f_19860_);
        float playerYaw = playerIn.f_19859_ + (playerIn.m_146908_() - playerIn.f_19859_);
        float yawRayX = Mth.m_14031_((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = Mth.m_14089_((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -Mth.m_14089_((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = Mth.m_14031_((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        Vec3 from = new Vec3(x, y, z);
        Vec3 to = from.m_82520_((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return new LookDirection(from, to);
    }

    public static HitResult rayTrace(Player p, boolean hitBlocks, boolean hitEntities) {
        Level level = p.m_20193_();
        float f = 1.0f;
        float f1 = p.f_19860_ + (p.m_146909_() - p.f_19860_) * 1.0f;
        float f2 = p.f_19859_ + (p.m_146908_() - p.f_19859_) * 1.0f;
        double d0 = p.f_19854_ + (p.m_20185_() - p.f_19854_) * 1.0;
        double d1 = p.f_19855_ + (p.m_20186_() - p.f_19855_) * 1.0 + 1.62 - p.m_6049_();
        double d2 = p.f_19856_ + (p.m_20189_() - p.f_19856_) * 1.0;
        Vec3 vec3 = new Vec3(d0, d1, d2);
        float f3 = Mth.m_14089_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = Mth.m_14031_((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 32.0;
        Vec3 vec31 = vec3.m_82520_((double)f7 * 32.0, (double)f6 * 32.0, (double)f8 * 32.0);
        AABB bb = new AABB(Math.min(vec3.f_82479_, vec31.f_82479_), Math.min(vec3.f_82480_, vec31.f_82480_), Math.min(vec3.f_82481_, vec31.f_82481_), Math.max(vec3.f_82479_, vec31.f_82479_), Math.max(vec3.f_82480_, vec31.f_82480_), Math.max(vec3.f_82481_, vec31.f_82481_)).m_82377_(16.0, 16.0, 16.0);
        Entity entity = null;
        double closest = 9999999.0;
        if (hitEntities) {
            List list = level.m_45933_((Entity)p, bb);
            for (Entity entity1 : list) {
                double nd;
                if (!entity1.m_6084_() || entity1 == p || entity1 instanceof ItemEntity || entity1.m_20367_((Entity)p)) continue;
                f1 = 0.3f;
                AABB boundingBox = entity1.m_142469_().m_82377_((double)f1, (double)f1, (double)f1);
                Vec3 rtResult = boundingBox.m_82371_(vec3, vec31).orElse(null);
                if (rtResult == null || !((nd = vec3.m_82557_(rtResult)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
        }
        EntityHitResult pos = null;
        Vec3 vec = null;
        if (hitBlocks) {
            vec = new Vec3(d0, d1, d2);
            pos = level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)p));
        }
        if (entity != null && pos != null && pos.m_82450_().m_82557_(vec) > closest) {
            pos = new EntityHitResult(entity);
        } else if (entity != null && pos == null) {
            pos = new EntityHitResult(entity);
        }
        return pos;
    }
}

