/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class PlotTestHelper
extends GameTestHelper {
    private final BlockPos plotTranslation;

    public PlotTestHelper(BlockPos plotTranslation, GameTestInfo gameTestInfo) {
        super(gameTestInfo);
        this.plotTranslation = plotTranslation;
    }

    public BlockPos m_177449_(BlockPos pos) {
        return super.m_177449_(pos.m_141952_((Vec3i)this.plotTranslation).m_142082_(0, 1, 0));
    }

    public BlockPos m_177452_(BlockPos pos) {
        return super.m_177452_(pos).m_142082_(-this.plotTranslation.m_123341_(), -this.plotTranslation.m_123342_(), -this.plotTranslation.m_123343_()).m_142082_(0, -1, 0);
    }

    public Vec3 m_177227_(Vec3 relativeVec3) {
        return super.m_177227_(relativeVec3).m_82520_((double)this.plotTranslation.m_123341_(), (double)this.plotTranslation.m_123342_(), (double)this.plotTranslation.m_123343_());
    }

    public IGrid getGrid(BlockPos pos) {
        this.checkAllInitialized();
        BlockEntity be = this.m_177347_(pos);
        if (be instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity gridConnectedBlockEntity = (IGridConnectedBlockEntity)be;
            return gridConnectedBlockEntity.getMainNode().getGrid();
        }
        if (be instanceof IInWorldGridNodeHost) {
            IInWorldGridNodeHost nodeHost = (IInWorldGridNodeHost)be;
            for (Direction side : Direction.values()) {
                IGridNode node = nodeHost.getGridNode(side);
                if (node == null) continue;
                return node.getGrid();
            }
        }
        throw new GameTestAssertException("No grid @ " + pos);
    }

    public void checkAllInitialized() {
        this.m_177292_(blockPos -> {
            BlockEntity be = this.m_177347_((BlockPos)blockPos);
            if (be instanceof IGridConnectedBlockEntity) {
                IGridConnectedBlockEntity gridConnectedBlockEntity = (IGridConnectedBlockEntity)be;
                this.check(gridConnectedBlockEntity.getMainNode().isReady(), "BE " + be + " is not ready");
            } else if (be instanceof IPartHost) {
                IPartHost partHost = (IPartHost)be;
                for (Direction side : Platform.DIRECTIONS_WITH_NULL) {
                    IPart part = partHost.getPart(side);
                    if (!(part instanceof AEBasePart)) continue;
                    AEBasePart basePart = (AEBasePart)part;
                    IManagedGridNode mainNode = basePart.getMainNode();
                    this.check(mainNode.isReady(), "Part " + part + " is not ready");
                }
            }
        });
    }

    public void assertContains(IGrid grid, Item item) {
        MEStorage storage = grid.getStorageService().getInventory();
        this.assertContains(storage, AEItemKey.of((ItemLike)item));
    }

    public void assertContains(MEStorage storage, AEKey key) {
        long count = storage.getAvailableStacks().get(key);
        if (count <= 0L) {
            throw new GameTestAssertException("Network storage does not contain " + key + ". Available keys: " + storage.getAvailableStacks().keySet());
        }
    }

    public void assertContainsNot(MEStorage storage, AEKey key) {
        long count = storage.getAvailableStacks().get(key);
        if (count > 0L) {
            throw new GameTestAssertException("Network storage does contains " + key + ".");
        }
    }

    public void clearStorage(IGrid grid) {
        this.clearStorage(grid.getStorageService().getInventory());
    }

    public void clearStorage(MEStorage storage) {
        KeyCounter counter = storage.getAvailableStacks();
        for (AEKey key : counter.keySet()) {
            storage.extract(key, Long.MAX_VALUE, Actionable.MODULATE, new BaseActionSource());
        }
    }

    public void check(boolean test, String errorMessage) throws GameTestAssertException {
        if (!test) {
            throw new GameTestAssertException(errorMessage);
        }
    }

    public KeyCounter countContainerContentAt(BlockPos pos) {
        KeyCounter counter = new KeyCounter();
        this.countContainerContentAt(pos, counter);
        return counter;
    }

    public void countContainerContentAt(BlockPos pos, KeyCounter counter) {
        BaseContainerBlockEntity container = (BaseContainerBlockEntity)this.m_177347_(pos);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.m_41619_()) continue;
            counter.add(AEItemKey.of(item), item.m_41613_());
        }
    }
}

