/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ITerminalHost;
import appeng.blockentity.misc.SecurityStationBlockEntity;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SecurityStationMenu
extends MEStorageMenu
implements InternalInventoryHost {
    private static final String ACTION_TOGGLE_PERMISSION = "togglePermission";
    public static final MenuType<SecurityStationMenu> TYPE = MenuTypeBuilder.create(SecurityStationMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.SECURITY).build("securitystation");
    private final RestrictedInputSlot configSlot;
    private final RestrictedInputSlot linkableIn;
    private final OutputSlot linkableOut;
    private final SecurityStationBlockEntity securityBox;
    @GuiSync(value=0)
    public int permissionMode = 0;

    public SecurityStationMenu(int id, Inventory ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, true);
        this.securityBox = (SecurityStationBlockEntity)monitorable;
        this.configSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BIOMETRIC_CARD, this.securityBox.getConfigSlot(), 0);
        this.addSlot(this.configSlot, SlotSemantics.BIOMETRIC_CARD);
        AppEngInternalInventory gridLinkingInv = new AppEngInternalInventory(this, 2);
        this.linkableIn = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.GRID_LINKABLE_ITEM, gridLinkingInv, 0);
        this.addSlot(this.linkableIn, SlotSemantics.MACHINE_INPUT);
        this.linkableOut = new OutputSlot(gridLinkingInv, 1, null);
        this.addSlot(this.linkableOut, SlotSemantics.MACHINE_OUTPUT);
        this.registerClientAction(ACTION_TOGGLE_PERMISSION, SecurityPermissions.class, this::toggleSetting);
    }

    public void toggleSetting(SecurityPermissions permission) {
        Item item;
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_TOGGLE_PERMISSION, permission);
            return;
        }
        ItemStack a = this.configSlot.m_7993_();
        if (!a.m_41619_() && (item = a.m_41720_()) instanceof IBiometricCard) {
            IBiometricCard bc = (IBiometricCard)item;
            if (bc.hasPermission(a, permission)) {
                bc.removePermission(a, permission);
            } else {
                bc.addPermission(a, permission);
            }
        }
    }

    @Override
    public void m_38946_() {
        Object object;
        this.verifyPermissions(SecurityPermissions.SECURITY, false);
        this.setPermissionMode(0);
        ItemStack a = this.configSlot.m_7993_();
        if (!a.m_41619_() && (object = a.m_41720_()) instanceof IBiometricCard) {
            IBiometricCard bc = (IBiometricCard)object;
            for (SecurityPermissions sp : bc.getPermissions(a)) {
                this.setPermissionMode(this.getPermissionMode() | 1 << sp.ordinal());
            }
        }
        this.updatePowerStatus();
        super.m_38946_();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.linkableIn.m_6657_()) {
            player.m_36176_(this.linkableIn.m_7993_(), false);
        }
        if (this.linkableOut.m_6657_()) {
            player.m_36176_(this.linkableOut.m_7993_(), false);
        }
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        ItemStack term;
        IGridLinkableHandler handler;
        if (!this.linkableOut.m_6657_() && this.linkableIn.m_6657_() && (handler = GridLinkables.get((ItemLike)(term = this.linkableIn.m_7993_().m_41777_()).m_41720_())) != null && handler.canLink(term)) {
            handler.link(term, this.securityBox.getSecurityKey());
            this.linkableIn.m_5852_(ItemStack.f_41583_);
            this.linkableOut.m_5852_(term);
        }
    }

    public int getPermissionMode() {
        return this.permissionMode;
    }

    private void setPermissionMode(int permissionMode) {
        this.permissionMode = permissionMode;
    }

    @Override
    protected boolean showsCraftables() {
        return false;
    }
}

