/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.api.integrations.jei.IngredientConverters;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.InscriberScreen;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.core.localization.ItemModText;
import appeng.integration.abstraction.JEIFacade;
import appeng.integration.modules.jei.AttunementCategory;
import appeng.integration.modules.jei.AttunementDisplay;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.EntropyManipulatorCategory;
import appeng.integration.modules.jei.FacadeRegistryPlugin;
import appeng.integration.modules.jei.FluidIngredientConverter;
import appeng.integration.modules.jei.GenericEntryStackHelper;
import appeng.integration.modules.jei.GhostIngredientHandler;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.ItemIngredientConverter;
import appeng.integration.modules.jei.JeiRuntimeAdapter;
import appeng.integration.modules.jei.throwinginwater.ThrowingInWaterCategory;
import appeng.integration.modules.jei.throwinginwater.ThrowingInWaterDisplay;
import appeng.integration.modules.jei.transfer.EncodePatternTransferHandler;
import appeng.integration.modules.jei.transfer.UseCraftingRecipeTransfer;
import appeng.items.parts.FacadeItem;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.me.items.WirelessCraftingTermMenu;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation TEXTURE = AppEng.makeId("textures/guis/jei.png");
    private static final ResourceLocation ID = new ResourceLocation("ae2", "core");

    public JEIPlugin() {
        IngredientConverters.register(new ItemIngredientConverter());
        IngredientConverters.register(new FluidIngredientConverter());
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{AEItems.FACADE.m_5456_()});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new ThrowingInWaterCategory(jeiHelpers.getGuiHelper()), new CondenserCategory(jeiHelpers.getGuiHelper()), new InscriberRecipeCategory(jeiHelpers.getGuiHelper()), new AttunementCategory(jeiHelpers), new EntropyManipulatorCategory(jeiHelpers)});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(new UseCraftingRecipeTransfer<CraftingTermMenu>(CraftingTermMenu.class, registration.getTransferHelper()), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler(new UseCraftingRecipeTransfer<WirelessCraftingTermMenu>(WirelessCraftingTermMenu.class, registration.getTransferHelper()), VanillaRecipeCategoryUid.CRAFTING);
        registration.addUniversalRecipeTransferHandler(new EncodePatternTransferHandler<PatternEncodingTermMenu>(PatternEncodingTermMenu.class, registration.getTransferHelper()));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registration.addRecipes(recipeManager.m_44054_(InscriberRecipe.TYPE).values(), InscriberRecipeCategory.UID);
        registration.addRecipes((Collection)ImmutableList.of((Object)((Object)CondenserOutput.MATTER_BALLS), (Object)((Object)CondenserOutput.SINGULARITY)), CondenserCategory.UID);
        registration.addRecipes(recipeManager.m_44054_(EntropyRecipe.TYPE).values(), EntropyManipulatorCategory.TYPE.getUid());
        this.registerP2PAttunement(registration);
        this.registerDescriptions(registration);
        ArrayList<ThrowingInWaterDisplay> inWater = new ArrayList<ThrowingInWaterDisplay>();
        if (AEConfig.instance().isInWorldCrystalGrowthEnabled()) {
            inWater.add(new ThrowingInWaterDisplay(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.CERTUS_CRYSTAL_SEED})), AEItems.CERTUS_QUARTZ_CRYSTAL.stack(), true));
            inWater.add(new ThrowingInWaterDisplay(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.FLUIX_CRYSTAL_SEED})), AEItems.FLUIX_CRYSTAL.stack(), true));
        }
        if (AEConfig.instance().isInWorldFluixEnabled()) {
            inWater.add(new ThrowingInWaterDisplay(List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42692_})), AEItems.FLUIX_DUST.stack(2), false));
        }
        registration.addRecipes(inWater, ThrowingInWaterCategory.ID);
    }

    private void registerP2PAttunement(IRecipeRegistration registration) {
        ArrayList<AttunementDisplay> attunementRecipes = new ArrayList<AttunementDisplay>();
        for (P2PTunnelAttunementInternal.Resultant resultant : P2PTunnelAttunementInternal.getApiTunnels()) {
            attunementRecipes.add(new AttunementDisplay(Ingredient.m_43927_((ItemStack[])((ItemStack[])Registry.f_122827_.m_123024_().map(ItemStack::new).filter(resultant.stackPredicate()).toArray(ItemStack[]::new))), resultant.tunnelType(), new Component[]{ItemModText.P2P_API_ATTUNEMENT.text(), resultant.description()}));
        }
        for (Map.Entry entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
            attunementRecipes.add(new AttunementDisplay(Ingredient.m_204132_((TagKey)((TagKey)entry.getKey())), (Item)entry.getValue(), new Component[]{ItemModText.P2P_TAG_ATTUNEMENT.text()}));
        }
        registration.addRecipes(AttunementCategory.TYPE, attunementRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack condenser = AEBlocks.CONDENSER.stack();
        registration.addRecipeCatalyst(condenser, new ResourceLocation[]{CondenserCategory.UID});
        ItemStack inscriber = AEBlocks.INSCRIBER.stack();
        registration.addRecipeCatalyst(inscriber, new ResourceLocation[]{InscriberRecipeCategory.UID});
        ItemStack craftingTerminal = AEParts.CRAFTING_TERMINAL.stack();
        registration.addRecipeCatalyst(craftingTerminal, new RecipeType[]{RecipeTypes.CRAFTING});
        ItemStack wirelessCraftingTerminal = AEItems.WIRELESS_CRAFTING_TERMINAL.stack();
        registration.addRecipeCatalyst(wirelessCraftingTerminal, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(AEItems.ENTROPY_MANIPULATOR.stack(), new RecipeType[]{EntropyManipulatorCategory.TYPE});
    }

    private void registerDescriptions(IRecipeRegistration registry) {
        this.addDescription(registry, AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, new Component[]{GuiText.ChargedQuartz.text()});
        this.addDescription(registry, AEItems.LOGIC_PROCESSOR_PRESS, new Component[]{GuiText.inWorldCraftingPresses.text()});
        this.addDescription(registry, AEItems.CALCULATION_PROCESSOR_PRESS, new Component[]{GuiText.inWorldCraftingPresses.text()});
        this.addDescription(registry, AEItems.ENGINEERING_PROCESSOR_PRESS, new Component[]{GuiText.inWorldCraftingPresses.text()});
        if (AEConfig.instance().isInWorldSingularityEnabled()) {
            this.addDescription(registry, AEItems.QUANTUM_ENTANGLED_SINGULARITY, new Component[]{GuiText.inWorldSingularity.text()});
        }
    }

    private void addDescription(IRecipeRegistration registry, ItemDefinition<?> itemDefinition, Component ... message) {
        registry.addIngredientInfo((Object)itemDefinition.stack(), (IIngredientType)VanillaTypes.ITEM_STACK, message);
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        if (AEConfig.instance().isEnableFacadesInJEI()) {
            FacadeItem itemFacade = AEItems.FACADE.m_5456_();
            ItemStack cableAnchor = AEParts.CABLE_ANCHOR.stack();
            registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new FacadeRegistryPlugin(itemFacade, cableAnchor));
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AEBaseScreen.class, new IGuiContainerHandler<AEBaseScreen<?>>(){

            public List<Rect2i> getGuiExtraAreas(AEBaseScreen<?> screen) {
                return screen.getExclusionZones();
            }

            @Nullable
            public Object getIngredientUnderMouse(AEBaseScreen<?> screen, double mouseX, double mouseY) {
                GenericStack stack = screen.getStackUnderMouse(mouseX, mouseY);
                if (stack != null) {
                    return GenericEntryStackHelper.stackToIngredient(stack);
                }
                return null;
            }

            public Collection<IGuiClickableArea> getGuiClickableAreas(AEBaseScreen<?> screen, double mouseX, double mouseY) {
                if (screen instanceof InscriberScreen) {
                    return Collections.singletonList(IGuiClickableArea.createBasic((int)82, (int)39, (int)26, (int)16, (ResourceLocation[])new ResourceLocation[]{InscriberRecipeCategory.UID}));
                }
                return Collections.emptyList();
            }
        });
        registration.addGhostIngredientHandler(AEBaseScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIFacade.setInstance(new JeiRuntimeAdapter(jeiRuntime));
        this.hideDebugTools(jeiRuntime);
    }

    private void hideDebugTools(IJeiRuntime jeiRuntime) {
        if (!AEConfig.instance().isDebugToolsEnabled()) {
            ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
            toRemove.add(AEBlocks.DEBUG_CUBE_GEN.stack());
            toRemove.add(AEBlocks.DEBUG_CHUNK_LOADER.stack());
            toRemove.add(AEBlocks.DEBUG_ENERGY_GEN.stack());
            toRemove.add(AEBlocks.DEBUG_ITEM_GEN.stack());
            toRemove.add(AEBlocks.DEBUG_PHANTOM_NODE.stack());
            toRemove.add(AEItems.DEBUG_CARD.stack());
            toRemove.add(AEItems.DEBUG_ERASER.stack());
            toRemove.add(AEItems.DEBUG_METEORITE_PLACER.stack());
            toRemove.add(AEItems.DEBUG_REPLICATOR_CARD.stack());
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, toRemove);
        }
    }
}

