/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.integrations.jei.IngredientConverter;
import appeng.api.integrations.jei.IngredientConverters;
import appeng.api.stacks.GenericStack;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;

public final class GenericEntryStackHelper {
    private GenericEntryStackHelper() {
    }

    @Nullable
    public static GenericStack ingredientToStack(Object ingredient) {
        for (IngredientConverter<?> converter : IngredientConverters.getConverters()) {
            GenericStack stack = GenericEntryStackHelper.tryConvertToStack(converter, ingredient);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public static Object stackToIngredient(GenericStack stack) {
        for (IngredientConverter<?> converter : IngredientConverters.getConverters()) {
            Object ingredient = converter.getIngredientFromStack(stack);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }

    @Nullable
    private static <T> GenericStack tryConvertToStack(IngredientConverter<T> converter, Object ingredient) {
        Class ingredientClass = converter.getIngredientType().getIngredientClass();
        if (ingredientClass.isInstance(ingredient)) {
            return converter.getStackFromIngredient(ingredientClass.cast(ingredient));
        }
        return null;
    }

    public static List<List<GenericStack>> ofInputs(IRecipeLayout recipeLayout) {
        return GenericEntryStackHelper.ofRecipeLayout(recipeLayout, IGuiIngredient::isInput);
    }

    public static List<GenericStack> ofOutputs(IRecipeLayout recipeLayout) {
        return GenericEntryStackHelper.ofRecipeLayout(recipeLayout, ingredient -> !ingredient.isInput()).stream().flatMap(e -> e.stream().limit(1L)).toList();
    }

    private static List<List<GenericStack>> ofRecipeLayout(IRecipeLayout recipeLayout, Predicate<IGuiIngredient<?>> predicate) {
        return IngredientConverters.getConverters().stream().flatMap(converter -> GenericEntryStackHelper.getConverted(converter, recipeLayout, predicate)).toList();
    }

    private static <T> Stream<List<GenericStack>> getConverted(IngredientConverter<T> converter, IRecipeLayout layout, Predicate<IGuiIngredient<?>> predicate) {
        return layout.getIngredientsGroup(converter.getIngredientType()).getGuiIngredients().entrySet().stream().filter(e -> predicate.test((IGuiIngredient)e.getValue())).sorted(Comparator.comparingInt(Map.Entry::getKey)).map(e -> converter.getStacksFromGuiIngredient((IGuiIngredient)e.getValue()));
    }
}

