/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.definitions.AEParts;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.jei.AttunementDisplay;
import appeng.integration.modules.jei.ViewBasedCategory;
import appeng.integration.modules.jei.widgets.View;
import appeng.integration.modules.jei.widgets.Widget;
import appeng.integration.modules.jei.widgets.WidgetFactory;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AttunementCategory
extends ViewBasedCategory<AttunementDisplay> {
    public static final RecipeType<AttunementDisplay> TYPE = RecipeType.create((String)"ae2", (String)"attunement", AttunementDisplay.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;

    public AttunementCategory(IJeiHelpers helpers) {
        super(helpers);
        IGuiHelper guiHelpers = helpers.getGuiHelper();
        this.background = guiHelpers.createBlankDrawable(130, 36);
        this.icon = guiHelpers.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AEParts.ME_P2P_TUNNEL.stack());
        this.slotBackground = guiHelpers.getSlotDrawable();
    }

    public ResourceLocation getUid() {
        return TYPE.getUid();
    }

    public Class<? extends AttunementDisplay> getRecipeClass() {
        return TYPE.getRecipeClass();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return ItemModText.P2P_TUNNEL_ATTUNEMENT.text();
    }

    public RecipeType<AttunementDisplay> getRecipeType() {
        return TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    protected View getView(final AttunementDisplay recipe) {
        final int x = this.background.getWidth() / 2 - 41;
        final int y = this.background.getHeight() / 2 - 13;
        return new View(){

            @Override
            public void buildSlots(IRecipeLayoutBuilder builder) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x + 4, y + 5).setBackground(AttunementCategory.this.slotBackground, -1, -1).addIngredients(recipe.inputs())).addTooltipCallback((recipeSlotView, tooltip) -> Collections.addAll(tooltip, recipe.description()));
                builder.addSlot(RecipeIngredientRole.OUTPUT, x + 61, y + 5).setBackground(AttunementCategory.this.slotBackground, -1, -1).addItemStack(new ItemStack((ItemLike)recipe.tunnel()));
            }

            @Override
            public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                widgets.add(factory.unfilledArrow(x + 27, y + 4));
            }
        };
    }
}

