/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.features.HotkeyAction;
import appeng.client.Hotkey;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.BasePacket;
import appeng.hotkeys.HotkeyActions;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class HotkeyPacket
extends BasePacket {
    private final String hotkey;

    public HotkeyPacket(FriendlyByteBuf stream) {
        this.hotkey = stream.m_130277_();
    }

    public HotkeyPacket(Hotkey hotkey) {
        this.hotkey = hotkey.name();
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130070_(this.hotkey);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        List<HotkeyAction> locatingServices = HotkeyActions.REGISTRY.get(this.hotkey);
        if (locatingServices == null) {
            player.m_6352_((Component)PlayerMessages.UnknownHotkey.text().m_6881_().m_7220_((Component)new TranslatableComponent("key.ae2." + this.hotkey)), Util.f_137441_);
            AELog.warn("Player %s tried using unknown hotkey \"%s\"", player, this.hotkey);
            return;
        }
        for (HotkeyAction hotkeyAction : locatingServices) {
            if (hotkeyAction.run((Player)player)) break;
        }
    }
}

