/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.render.effects.EnergyParticleData;
import appeng.core.AELog;
import appeng.core.AppEngClient;
import appeng.core.sync.BasePacket;
import appeng.util.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.GameData;

public class BlockTransitionEffectPacket
extends BasePacket {
    private final BlockPos pos;
    private final BlockState blockState;
    private final Direction direction;
    private final SoundMode soundMode;

    public BlockTransitionEffectPacket(BlockPos pos, BlockState blockState, Direction direction, SoundMode soundMode) {
        this.pos = pos;
        this.blockState = blockState;
        this.direction = direction;
        this.soundMode = soundMode;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130064_(pos);
        int blockStateId = GameData.getBlockStateIDMap().m_7447_((Object)blockState);
        if (blockStateId == -1) {
            AELog.warn("Failed to find numeric id for block state %s", blockState);
        }
        data.writeInt(blockStateId);
        data.writeByte(this.direction.ordinal());
        data.writeByte((int)((byte)soundMode.ordinal()));
        this.configureWrite(data);
    }

    public BlockTransitionEffectPacket(FriendlyByteBuf stream) {
        this.pos = stream.m_130135_();
        int blockStateId = stream.readInt();
        BlockState blockState = (BlockState)GameData.getBlockStateIDMap().m_7942_(blockStateId);
        if (blockState == null) {
            AELog.warn("Received invalid blockstate id %d from server", blockStateId);
            blockState = Blocks.f_50016_.m_49966_();
        }
        this.blockState = blockState;
        this.direction = Direction.values()[stream.readByte()];
        this.soundMode = SoundMode.values()[stream.readByte()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(Player player) {
        this.spawnParticles();
        this.playBreakOrPickupSound();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        EnergyParticleData data = new EnergyParticleData(false, this.direction);
        for (int zz = 0; zz < 32; ++zz) {
            if (!AppEngClient.instance().shouldAddParticles(Platform.getRandom())) continue;
            double x = (float)this.pos.m_123341_() + Platform.getRandomFloat();
            double y = (float)this.pos.m_123342_() + Platform.getRandomFloat();
            double z = (float)this.pos.m_123343_() + Platform.getRandomFloat();
            double speedX = 0.1f * (float)this.direction.m_122429_();
            double speedY = 0.1f * (float)this.direction.m_122430_();
            double speedZ = 0.1f * (float)this.direction.m_122431_();
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)data, x, y, z, speedX, speedY, speedZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playBreakOrPickupSound() {
        float pitch;
        float volume;
        SoundEvent soundEvent;
        if (this.soundMode == SoundMode.FLUID) {
            Fluid fluid = this.blockState.m_60819_().m_76152_();
            soundEvent = fluid.getAttributes().getFillSound();
            if (soundEvent == null) {
                soundEvent = fluid.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11783_ : SoundEvents.f_11781_;
            }
            volume = 1.0f;
            pitch = 1.0f;
        } else if (this.soundMode == SoundMode.BLOCK) {
            SoundType soundType = this.blockState.m_60827_();
            soundEvent = soundType.m_56775_();
            volume = soundType.f_56731_;
            pitch = soundType.f_56732_;
        } else {
            return;
        }
        SimpleSoundInstance sound = new SimpleSoundInstance(soundEvent, SoundSource.BLOCKS, (volume + 1.0f) / 2.0f, pitch * 0.8f, this.pos);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
    }

    public static enum SoundMode {
        BLOCK,
        FLUID,
        NONE;

    }
}

