/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PatternProviderBlockEntity
extends AENetworkBlockEntity
implements PatternProviderLogicHost {
    private final PatternProviderLogic logic = new PatternProviderLogic(this.getMainNode(), this);
    private boolean omniDirectional = true;

    public PatternProviderBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.logic.onMainNodeStateChanged();
    }

    public void setSide(Direction facing) {
        Object newForward = !this.omniDirectional && this.getForward() == facing.m_122424_() ? facing : (!this.omniDirectional && (this.getForward() == facing || this.getForward() == facing.m_122424_()) ? null : (this.omniDirectional ? facing.m_122424_() : Platform.rotateAround(this.getForward(), facing)));
        this.setPushDirection((Direction)newForward);
    }

    public void setPushDirection(@javax.annotation.Nullable Direction direction) {
        boolean bl = this.omniDirectional = direction == null;
        if (direction == null) {
            direction = Direction.NORTH;
        }
        Direction newUp = Direction.UP;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            newUp = Direction.NORTH;
        }
        this.setOrientation(direction, newUp);
        if (!this.isClientSide()) {
            this.configureNodeSides();
            this.markForUpdate();
            this.saveChanges();
        }
    }

    private void configureNodeSides() {
        if (this.omniDirectional) {
            this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
        } else {
            this.getMainNode().setExposedOnSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        }
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        this.logic.addDrops(drops);
    }

    @Override
    public void onReady() {
        this.configureNodeSides();
        super.onReady();
        this.logic.updatePatterns();
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128379_("omniDirectional", this.omniDirectional);
        this.logic.writeToNBT(data);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.omniDirectional = data.m_128471_("omniDirectional");
        this.logic.readFromNBT(data);
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean oldOmniDirectional = this.omniDirectional;
        this.omniDirectional = data.readBoolean();
        return oldOmniDirectional != this.omniDirectional || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.omniDirectional);
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public PatternProviderLogic getLogic() {
        return this.logic;
    }

    @Override
    public EnumSet<Direction> getTargets() {
        if (this.omniDirectional) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.of(this.getForward());
    }

    @Override
    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(output);
        }
    }

    @Override
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.importSettings(input, player);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @javax.annotation.Nullable Direction side) {
        LazyOptional<T> lo = this.logic.getCapability(cap);
        if (lo.isPresent()) {
            return lo;
        }
        return super.getCapability(cap, side);
    }

    public boolean isOmniDirectional() {
        return this.omniDirectional;
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return AEBlocks.PATTERN_PROVIDER.stack();
    }
}

