/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.tank.util;

import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DualTankHook {
    private final WeakReference<BlockEntity> tile;
    private final Direction dir1;
    private final Direction dir2;
    private boolean allowDuplicates;
    private int timeout;
    private int timeCounter;
    private LazyOptional<IFluidHandler> tank1;
    private LazyOptional<IFluidHandler> tank2;

    public DualTankHook(BlockEntity tile, Direction dir1, Direction dir2) {
        this.tile = new WeakReference<BlockEntity>(tile);
        this.dir1 = dir1;
        this.dir2 = dir2;
        this.allowDuplicates = false;
        this.timeCounter = 0;
        this.timeout = 0;
    }

    public DualTankHook allowDuplicates() {
        this.allowDuplicates = true;
        return this;
    }

    public DualTankHook setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public IFluidHandler getTank1() {
        return (IFluidHandler)this.tank1.orElseThrow(NullPointerException::new);
    }

    public IFluidHandler getTank2() {
        return (IFluidHandler)this.tank2.orElseThrow(NullPointerException::new);
    }

    public boolean tank1Present() {
        return this.tank1 != null && this.tank1.isPresent();
    }

    public boolean tank2Present() {
        return this.tank2 != null && this.tank2.isPresent();
    }

    public boolean checkTankContents(Fluid fluid1, Fluid fluid2) {
        if (!this.checkTanks()) {
            return false;
        }
        if (fluid1 != null && this.getTank1().getFluidInTank(0).getFluid() != fluid1) {
            return false;
        }
        return fluid2 == null || this.getTank2().getFluidInTank(0).getFluid() == fluid2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTanks() {
        LazyOptional f;
        BlockEntity tile;
        BlockEntity tile_ = (BlockEntity)this.tile.get();
        if (tile_ == null) {
            throw new IllegalStateException();
        }
        Level world = tile_.m_58904_();
        BlockPos pos = tile_.m_58899_();
        boolean check = false;
        if (!this.tank1Present()) {
            if (this.timeCounter > 0) {
                --this.timeCounter;
                return false;
            }
            check = true;
            tile = world.m_7702_(pos.m_142300_(this.dir1));
            if (tile == null) return false;
            f = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN);
            if (f.isPresent()) {
                this.tank1 = f;
                if (!this.allowDuplicates && this.tank2Present() && this.getTank2().equals(this.getTank1())) {
                    this.tank1 = null;
                    return false;
                }
            } else {
                this.tank1 = null;
                return false;
            }
        }
        if (!this.tank2Present()) {
            if (this.timeCounter > 0) {
                --this.timeCounter;
                return false;
            }
            check = true;
            tile = world.m_7702_(pos.m_142300_(this.dir2));
            if (tile == null) return false;
            f = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP);
            if (f.isPresent()) {
                this.tank2 = f;
                if (!this.allowDuplicates && this.tank1Present() && this.getTank1().equals(this.getTank2())) {
                    this.tank2 = null;
                    return false;
                }
            } else {
                this.tank2 = null;
                return false;
            }
        }
        if (!check) return true;
        this.timeCounter = this.timeout;
        return true;
    }
}

