/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.data;

import mcjty.deepresonance.modules.generator.block.GeneratorPartTileEntity;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.generator.util.GeneratorConfig;
import net.minecraftforge.energy.IEnergyStorage;

public class NetworkEnergyStorage
implements IEnergyStorage {
    private final GeneratorPartTileEntity part;

    public NetworkEnergyStorage(GeneratorPartTileEntity part) {
        this.part = part;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int consumeEnergy(int amount) {
        GeneratorBlob blob = this.part.getBlob();
        if (blob != null) {
            int energy = blob.getEnergy();
            if (amount > energy) {
                amount = energy;
            }
            blob.setEnergy(energy -= amount);
            return amount;
        }
        return 0;
    }

    public int getEnergyStored() {
        GeneratorBlob blob = this.part.getBlob();
        if (blob != null) {
            return blob.getEnergy();
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        GeneratorBlob blob = this.part.getBlob();
        if (blob != null) {
            return blob.getGeneratorBlocks() * (Integer)GeneratorConfig.POWER_STORAGE_PER_BLOCK.get();
        }
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }
}

