/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.client.gui.IScreenProvider;
import net.mehvahdjukaar.supplementaries.client.gui.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.client.particles.ParticleUtil;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundOpenScreenPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSpawnBlockParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.ModList;

public class ClientReceivers {
    private static void withPlayerDo(Consumer<Player> action) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            action.accept((Player)player);
        }
    }

    private static void withLevelDo(Consumer<Level> action) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            action.accept((Level)level);
        }
    }

    public static void handleOpenScreenPacket(ClientBoundOpenScreenPacket message) {
        ClientReceivers.withLevelDo(l -> {
            BlockPos pos = message.getPos();
            BlockEntity patt2212$temp = l.m_7702_(pos);
            if (patt2212$temp instanceof IScreenProvider) {
                IScreenProvider tile = (IScreenProvider)patt2212$temp;
                if (tile instanceof BlackboardBlockTile && !((Boolean)ClientConfigs.block.BLACKBOARD_GUI.get()).booleanValue()) {
                    return;
                }
                ClientReceivers.withPlayerDo(p -> tile.openScreen((Level)l, pos, (Player)p));
            }
        });
    }

    public static void handlePlaySpeakerMessagePacket(ClientBoundPlaySpeakerMessagePacket message) {
        boolean narrator = message.narrator;
        Component str = message.str;
        if (narrator && !ClientConfigs.cached.SPEAKER_BLOCK_MUTE) {
            Narrator.getNarrator().say(str.getString(), true);
        } else {
            ClientReceivers.withPlayerDo(p -> p.m_6352_(str, Util.f_137441_));
        }
    }

    public static void handleSendBombKnockbackPacket(ClientBoundSendKnockbackPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.id);
            if (e != null) {
                e.m_20256_(e.m_20184_().m_82520_(message.knockbackX, message.knockbackY, message.knockbackZ));
            }
        });
    }

    public static void handleLoginPacket(ClientBoundSendLoginPacket message) {
        ClientReceivers.withPlayerDo(p -> {
            PlayerSuggestionBoxWidget.USERNAME_CACHE = message.usernameCache;
            if (((Boolean)ClientConfigs.general.ANTI_REPOST_WARNING.get()).booleanValue()) {
                try {
                    String fileName = ModList.get().getModFileById("supplementaries").getFile().getFileName();
                    if (fileName.contains(".jar") && fileName.contains("-Mod-1")) {
                        TranslatableComponent link = new TranslatableComponent("message.supplementaries.anti_repost_link");
                        String url = "http://www.curseforge.com/minecraft/mc-mods/supplementaries";
                        ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
                        link.m_6270_(link.m_7383_().m_131142_(click).setUnderlined(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)));
                        p.m_6352_((Component)new TranslatableComponent("message.supplementaries.anti_repost", new Object[]{link}), Util.f_137441_);
                        p.m_6352_((Component)new TranslatableComponent("message.supplementaries.anti_repost_2"), Util.f_137441_);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void handleSpawnBlockParticlePacket(ClientBoundSpawnBlockParticlePacket message) {
        ClientReceivers.withLevelDo(l -> {
            switch (message.id) {
                case BUBBLE_BLOW: {
                    ParticleUtil.spawnParticlesOnBlockFaces(l, new BlockPos(message.pos), (ParticleOptions)ModRegistry.SUDS_PARTICLE.get(), UniformInt.m_146622_((int)2, (int)4), 0.001f, 0.01f, true);
                    break;
                }
                case BUBBLE_CLEAN: {
                    ParticleUtil.spawnParticleOnBlockShape(l, new BlockPos(message.pos), (ParticleOptions)ModRegistry.SUDS_PARTICLE.get(), UniformInt.m_146622_((int)2, (int)4), 0.01f);
                    break;
                }
                case DISPENSER_MINECART: {
                    boolean j1 = false;
                    boolean j2 = true;
                    boolean k2 = false;
                    double d18 = message.pos.f_82479_ + (double)j1 * 0.6;
                    double d24 = message.pos.f_82480_ + (double)j2 * 0.6;
                    double d28 = message.pos.f_82481_ + (double)k2 * 0.6;
                    for (int i3 = 0; i3 < 10; ++i3) {
                        double d4 = l.f_46441_.nextDouble() * 0.2 + 0.01;
                        double d6 = d18 + (double)j1 * 0.01 + (l.f_46441_.nextDouble() - 0.5) * (double)k2 * 0.5;
                        double d8 = d24 + (double)j2 * 0.01 + (l.f_46441_.nextDouble() - 0.5) * (double)j2 * 0.5;
                        double d30 = d28 + (double)k2 * 0.01 + (l.f_46441_.nextDouble() - 0.5) * (double)j1 * 0.5;
                        double d9 = (double)j1 * d4 + l.f_46441_.nextGaussian() * 0.01;
                        double d10 = (double)j2 * d4 + l.f_46441_.nextGaussian() * 0.01;
                        double d11 = (double)k2 * d4 + l.f_46441_.nextGaussian() * 0.01;
                        l.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d6, d8, d30, d9, d10, d11);
                    }
                    break;
                }
            }
        });
    }

    public static void handleSyncAntiqueInkPacket(ClientBoundSyncAntiqueInk message) {
        ClientReceivers.withLevelDo(l -> {
            BlockEntity tile = l.m_7702_(message.getPos());
            if (tile != null) {
                tile.getCapability(CapabilityHandler.ANTIQUE_TEXT_CAP).ifPresent(c -> c.setAntiqueInk(message.getInk()));
            }
        });
    }

    public static void handleSyncTradesPacket(ClientBoundSyncTradesPacket message) {
        ClientReceivers.withPlayerDo(p -> {
            AbstractContainerMenu container = p.f_36096_;
            if (message.getContainerId() == container.f_38840_ && container instanceof RedMerchantContainerMenu) {
                RedMerchantContainerMenu containerMenu = (RedMerchantContainerMenu)container;
                containerMenu.setOffers(new MerchantOffers(message.offers.m_45388_()));
                containerMenu.setXp(message.getVillagerXp());
                containerMenu.setMerchantLevel(message.getVillagerLevel());
                containerMenu.setShowProgressBar(message.isShowProgress());
                containerMenu.setCanRestock(message.isCanRestock());
            }
        });
    }

    public static void handlePlaySongNotesPacket(ClientBoundPlaySongNotesPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Player p;
            Item patt8150$temp;
            Entity e = l.m_6815_(message.entityID);
            if (e instanceof Player && (patt8150$temp = (p = (Player)e).m_21211_().m_41720_()) instanceof InstrumentItem) {
                InstrumentItem instrumentItem = (InstrumentItem)patt8150$temp;
                IntListIterator intListIterator = message.notes.iterator();
                while (intListIterator.hasNext()) {
                    int note = (Integer)intListIterator.next();
                    if (note <= 0) continue;
                    l.m_6263_((Player)Minecraft.m_91087_().f_91074_, p.m_20185_(), p.m_20186_(), p.m_20189_(), instrumentItem.getSound(), SoundSource.PLAYERS, instrumentItem.getVolume(), instrumentItem.getPitch(note));
                    instrumentItem.spawnNoteParticle((Level)l, (LivingEntity)p, note);
                }
            }
        });
    }
}

