/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.util.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.util.TextHolder;
import net.mehvahdjukaar.supplementaries.common.inventories.NoticeBoardContainerMenu;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.cctweaked.CCPlugin;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements Nameable,
IMapDisplay {
    private String text = null;
    private int fontScale = 1;
    private List<FormattedCharSequence> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;
    private Material cachedPattern = null;
    private boolean powered = false;
    private int pageNumber = 0;
    private DyeColor textColor = DyeColor.BLACK;
    private boolean textVisible = true;
    private final TextHolder textHolder = new TextHolder(1);

    public NoticeBoardBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.NOTICE_BOARD_TILE.get(), pos, state);
    }

    public Component m_6820_() {
        return new TranslatableComponent("block.supplementaries.notice_board");
    }

    public void updateTileOnInventoryChanged() {
        boolean shouldHaveBook = !this.getDisplayedItem().m_41619_();
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61440_) != shouldHaveBook) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61440_, (Comparable)Boolean.valueOf(shouldHaveBook)), 2);
            if (shouldHaveBook) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.85f);
            } else {
                this.pageNumber = 0;
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.5f);
            }
        }
    }

    @Override
    public ItemStack getMapStack() {
        return this.getDisplayedItem();
    }

    public void updateClientVisualsOnLoad() {
        ItemStack itemstack = this.getDisplayedItem();
        Item item2 = itemstack.m_41720_();
        this.cachedPattern = null;
        if (item2 instanceof BannerPatternItem) {
            BannerPatternItem bannerPatternItem = (BannerPatternItem)item2;
            this.cachedPattern = ClientRegistry.FLAG_MATERIALS.get().get(bannerPatternItem.m_40555_());
        }
        this.needsVisualRefresh = true;
        this.cachedPageLines = Collections.emptyList();
        this.text = null;
    }

    public void updateText() {
        ItemStack itemstack = this.getDisplayedItem();
        Item item2 = itemstack.m_41720_();
        CompoundTag com = itemstack.m_41783_();
        if (item2 instanceof WrittenBookItem && WrittenBookItem.m_43471_((CompoundTag)com) || item2 instanceof WritableBookItem && WritableBookItem.m_43452_((CompoundTag)com)) {
            ListTag pages = com.m_128437_("pages", 8).m_6426_();
            if (pages.size() > 0) {
                if (this.pageNumber >= pages.size()) {
                    this.pageNumber %= pages.size();
                }
                this.text = pages.m_128778_(this.pageNumber);
            }
        } else if (CompatHandler.computercraft && CCPlugin.checkForPrintedBook(item2) && com != null) {
            int pages = CCPlugin.getPages(itemstack);
            if (this.pageNumber >= pages) {
                this.pageNumber %= pages;
            }
            String[] text = CCPlugin.getText(itemstack);
            StringBuilder combined = new StringBuilder();
            for (int i = 0; i < 21; ++i) {
                int ind = this.pageNumber * 21 + i;
                if (ind >= text.length) continue;
                combined.append(text[ind]);
                combined.append(" ");
            }
            this.text = combined.toString();
        }
    }

    public void m_142466_(CompoundTag compound) {
        this.textColor = DyeColor.m_41057_((String)compound.m_128461_("Color"), (DyeColor)DyeColor.BLACK);
        this.textVisible = compound.m_128471_("TextVisible");
        this.pageNumber = compound.m_128451_("PageNumber");
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("Color", this.textColor.m_41065_());
        tag.m_128379_("TextVisible", this.textVisible);
        tag.m_128405_("PageNumber", this.pageNumber);
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new NoticeBoardContainerMenu(id, player, (Container)this);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.m_7983_() && (ServerConfigs.cached.NOTICE_BOARDS_UNRESTRICTED || NoticeBoardBlockTile.isPageItem(stack.m_41720_()));
    }

    public static boolean isPageItem(Item item2) {
        return item2.m_204114_().m_203656_(ItemTags.f_13162_) || item2 instanceof MapItem || item2 instanceof BannerPatternItem || CompatHandler.computercraft && CCPlugin.checkForPrintedBook(item2);
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.getTextColor()) {
            this.textColor = newColor;
            return true;
        }
        return false;
    }

    public boolean shouldSkipTileRenderer() {
        return !this.textVisible || (Boolean)this.m_58900_().m_61143_((Property)NoticeBoardBlock.HAS_BOOK) == false;
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    public Material getCachedPattern() {
        return this.cachedPattern;
    }

    public String getText() {
        return this.text;
    }

    public int getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(int s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<FormattedCharSequence> l) {
        this.cachedPageLines = l;
    }

    public List<FormattedCharSequence> getCachedPageLines() {
        return this.cachedPageLines;
    }

    public boolean getFlag() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)NoticeBoardBlock.FACING);
    }

    public void updatePower(boolean powered) {
        if (powered != this.powered && powered) {
            ++this.pageNumber;
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 1.45f);
            this.m_6596_();
        }
        this.powered = powered;
    }

    public InteractionResult interact(Player player, InteractionHand handIn, BlockPos pos, BlockState state) {
        boolean server;
        ItemStack itemStack = player.m_21120_(handIn);
        boolean bl = server = !player.f_19853_.f_46443_;
        if (player.m_6144_() && !this.m_7983_()) {
            if (server) {
                ItemStack it = this.m_8016_(0);
                BlockPos newPos = pos.m_141952_(((Direction)state.m_61143_((Property)NoticeBoardBlock.FACING)).m_122436_());
                ItemEntity drop = new ItemEntity(player.f_19853_, (double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5, it);
                drop.m_32060_();
                player.f_19853_.m_7967_((Entity)drop);
                this.m_6596_();
            }
        } else if (!super.interact(player, handIn).m_19077_() && server) {
            player.m_5893_((MenuProvider)this);
        }
        return InteractionResult.m_19078_((!server ? 1 : 0) != 0);
    }
}

