/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HourGlassBlockTile
extends ItemDisplayTile {
    public HourGlassSandType sandType = HourGlassSandType.DEFAULT;
    public float progress = 0.0f;
    public float prevProgress = 0.0f;
    public int power = 0;
    private TextureAtlasSprite cachedTexture = null;

    public HourGlassBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.HOURGLASS_TILE.get(), pos, state);
    }

    public void updateTileOnInventoryChanged() {
        this.sandType = HourGlassSandType.getHourGlassSandType(this.getDisplayedItem().m_41720_());
        boolean p = this.getDirection() == Direction.DOWN;
        int l = this.sandType.getLight();
        if (l != (Integer)this.m_58900_().m_61143_((Property)HourGlassBlock.LIGHT_LEVEL) && this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)HourGlassBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(l)), 20);
        }
        this.prevProgress = (float)p;
        this.progress = (float)p;
    }

    public TextureAtlasSprite getOrCreateSprite() {
        if (this.cachedTexture == null) {
            this.cachedTexture = this.sandType.getSprite(this.getDisplayedItem(), this.f_58857_);
        }
        return this.cachedTexture;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, HourGlassBlockTile tile) {
        int p;
        Direction dir = (Direction)pState.m_61143_((Property)HourGlassBlock.FACING);
        if (!tile.sandType.isEmpty()) {
            tile.prevProgress = tile.progress;
            if (dir == Direction.UP && tile.progress != 1.0f) {
                tile.progress = Math.min(tile.progress + tile.sandType.increment, 1.0f);
            } else if (dir == Direction.DOWN && tile.progress != 0.0f) {
                tile.progress = Math.max(tile.progress - tile.sandType.increment, 0.0f);
            }
        }
        if (!pLevel.f_46443_ && (p = dir == Direction.DOWN ? (int)((1.0f - tile.progress) * 15.0f) : (int)(tile.progress * 15.0f)) != tile.power) {
            tile.power = p;
            pLevel.m_46717_(pPos, pState.m_60734_());
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        int i = compound.m_128451_("SandType");
        this.sandType = HourGlassSandType.values()[Math.min(i, HourGlassSandType.values().length)];
        this.progress = compound.m_128457_("Progress");
        this.prevProgress = compound.m_128457_("PrevProgress");
        this.cachedTexture = null;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SandType", this.sandType.ordinal());
        tag.m_128350_("Progress", this.progress);
        tag.m_128350_("PrevProgress", this.prevProgress);
    }

    public Component m_6820_() {
        return new TranslatableComponent("block.supplementaries.hourglass");
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.m_7983_() && !HourGlassSandType.getHourGlassSandType(stack.m_41720_()).isEmpty();
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (direction == Direction.UP) {
            return this.m_7013_(0, stack);
        }
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)HourGlassBlock.FACING);
        return dir == Direction.UP && this.progress == 1.0f || dir == Direction.DOWN && this.progress == 0.0f;
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)HourGlassBlock.FACING);
    }

    public static enum HourGlassSandType {
        DEFAULT(null, null, 0),
        SAND(Textures.SAND_TEXTURE, null, (Integer)ServerConfigs.block.HOURGLASS_SAND.get()),
        CONCRETE(Textures.WHITE_CONCRETE_TEXTURE, null, (Integer)ServerConfigs.block.HOURGLASS_CONCRETE.get()),
        GUNPOWDER(Textures.HOURGLASS_GUNPOWDER, Items.f_42403_, (Integer)ServerConfigs.block.HOURGLASS_DUST.get()),
        SUGAR(Textures.HOURGLASS_SUGAR, Items.f_42501_, (Integer)ServerConfigs.block.HOURGLASS_SUGAR.get()),
        GLOWSTONE_DUST(Textures.HOURGLASS_GLOWSTONE, Items.f_42525_, (Integer)ServerConfigs.block.HOURGLASS_GLOWSTONE.get()),
        REDSTONE_DUST(Textures.HOURGLASS_REDSTONE, Items.f_42451_, (Integer)ServerConfigs.block.HOURGLASS_REDSTONE.get()),
        BLAZE_POWDER(Textures.HOURGLASS_BLAZE, Items.f_42593_, (Integer)ServerConfigs.block.HOURGLASS_BLAZE_POWDER.get()),
        FORGE_DUST(Textures.HOURGLASS_GUNPOWDER, null, (Integer)ServerConfigs.block.HOURGLASS_DUST.get()),
        HONEY(Textures.HONEY_TEXTURE, Items.f_42787_, (Integer)ServerConfigs.block.HOURGLASS_HONEY.get()),
        SLIME(Textures.SLIME_TEXTURE, Items.f_42518_, (Integer)ServerConfigs.block.HOURGLASS_SLIME.get());

        @Nullable
        public final ResourceLocation texture;
        @Nullable
        public final Item item;
        public final float increment;

        private HourGlassSandType(ResourceLocation texture, Item item2, int t) {
            this.texture = texture;
            this.item = item2;
            this.increment = 1.0f / (float)t;
        }

        public boolean isEmpty() {
            return this == DEFAULT;
        }

        public int getLight() {
            if (this == GLOWSTONE_DUST) {
                return 9;
            }
            if (this == BLAZE_POWDER) {
                return 6;
            }
            return 0;
        }

        public TextureAtlasSprite getSprite(ItemStack i, Level world) {
            Minecraft mc = Minecraft.m_91087_();
            if (this == FORGE_DUST || this == SAND || this == CONCRETE) {
                ItemRenderer itemRenderer = mc.m_91291_();
                BakedModel model = itemRenderer.m_174264_(i, world, null, 0);
                TextureAtlasSprite sprite = model.m_6160_();
                if (sprite instanceof MissingTextureAtlasSprite) {
                    sprite = (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(this.texture);
                }
                return sprite;
            }
            return (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(this.texture);
        }

        public static HourGlassSandType getHourGlassSandType(Item i) {
            if (i instanceof BlockItem) {
                BlockItem bi = (BlockItem)i;
                Block b = bi.m_40614_();
                if (i.m_204114_().m_203656_(ModTags.SANDS)) {
                    return SAND;
                }
                if (b.m_204297_().m_203656_(ModTags.CONCRETE_POWDERS)) {
                    return CONCRETE;
                }
            }
            for (HourGlassSandType n : HourGlassSandType.values()) {
                if (n.item != i) continue;
                return n;
            }
            if (i.m_204114_().m_203656_(ModTags.DUSTS)) {
                return FORGE_DUST;
            }
            return DEFAULT;
        }
    }
}

