/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.datagen.server;

import com.davenonymous.libnonymous.datagen.BaseDataProvider;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class DatagenSoils
extends BaseDataProvider {
    public DatagenSoils(DataGenerator generator) {
        super(generator, BaseDataProvider.Type.DATA);
    }

    public String getModId() {
        return "bonsaitrees3";
    }

    public void addValues() {
        this.addSoil(Items.f_41830_, Blocks.f_49992_, 1.0, new String[]{"sand"});
        this.addSoil(Items.f_42329_, Blocks.f_50493_, 1.1, new String[]{"dirt"});
        this.addSoil(Items.f_42276_, Blocks.f_50440_, 1.0, new String[]{"grass"});
        this.addSoil(Items.f_42102_, Blocks.f_50259_, 1.0, new String[]{"end_stone"});
        this.addSoil(Items.f_42048_, Blocks.f_50134_, 0.9, new String[]{"netherrack"});
        this.addSoil(Items.f_42259_, Blocks.f_50451_, 1.0, new String[]{"netherrack"});
        this.addSoil(Items.f_42488_, Blocks.f_50699_, 1.0, new String[]{"crimson"});
        this.addSoil(Items.f_42541_, Blocks.f_50690_, 1.0, new String[]{"warped"});
        this.addSoil(Items.f_42093_, Blocks.f_50195_, 1.0, new String[]{"mycelium"});
        this.addSoil(Items.f_42447_, (Fluid)Fluids.f_76193_, 1.0, new String[]{"water"});
        this.addSoil(Items.f_42448_, (Fluid)Fluids.f_76195_, 1.0, new String[]{"lava"});
    }

    private JsonObject buildDefault(Item item, double tickModifier, String[] compatibleTags) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "bonsaitrees3:soil");
        root.addProperty("mod", "minecraft");
        root.addProperty("tickModifier", (Number)tickModifier);
        JsonObject soilItem = new JsonObject();
        soilItem.addProperty("item", item.getRegistryName().toString());
        root.add("soil", (JsonElement)soilItem);
        if (compatibleTags.length > 0) {
            JsonArray tags = new JsonArray();
            Arrays.stream(compatibleTags).forEach(s -> tags.add(s));
            root.add("compatibleSoilTags", (JsonElement)tags);
        }
        return root;
    }

    private void addSoil(Item item, Fluid displayFluid, double tickModifier, String[] compatibleTags) {
        JsonObject root = this.buildDefault(item, tickModifier, compatibleTags);
        JsonObject displayObj = new JsonObject();
        displayObj.addProperty("fluid", displayFluid.getRegistryName().toString());
        root.add("display", (JsonElement)displayObj);
        this.add("recipes/soil/" + item.getRegistryName().m_135827_() + "/" + item.getRegistryName().m_135815_(), root);
    }

    private void addSoil(Item item, Block displayBlock, double tickModifier, String[] compatibleTags) {
        JsonObject root = this.buildDefault(item, tickModifier, compatibleTags);
        JsonObject displayObj = new JsonObject();
        displayObj.addProperty("block", displayBlock.getRegistryName().toString());
        root.add("display", (JsonElement)displayObj);
        this.add("recipes/soil/" + item.getRegistryName().m_135827_() + "/" + item.getRegistryName().m_135815_(), root);
    }

    public String m_6055_() {
        return "Bonsai Trees Soil Types";
    }
}

