/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.datagen.server;

import com.davenonymous.bonsaitrees3.registry.sapling.SaplingDrop;
import com.davenonymous.libnonymous.datagen.BaseDataProvider;
import com.davenonymous.libnonymous.reflections.BlockStateProviderReflection;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatagenSaplings
extends BaseDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();

    public DatagenSaplings(DataGenerator generator) {
        super(generator, BaseDataProvider.Type.DATA);
    }

    public String getModId() {
        return "bonsaitrees3";
    }

    public void addValues() {
        this.addSapling(Items.f_41827_, (ConfiguredFeature)TreeFeatures.f_195126_.m_203334_());
        this.addSapling(Items.f_42801_, (ConfiguredFeature)TreeFeatures.f_195125_.m_203334_());
        this.addSapling(Items.f_41828_, (ConfiguredFeature)TreeFeatures.f_195124_.m_203334_());
        this.addSapling(Items.f_41826_, (ConfiguredFeature)TreeFeatures.f_195129_.m_203334_(), DatagenSaplings.fruitDrop(Items.f_42533_));
        this.addSapling(Items.f_42799_, (ConfiguredFeature)TreeFeatures.f_195123_.m_203334_(), DatagenSaplings.fruitDrop(Items.f_42410_));
        this.addSapling(Items.f_42800_, (ConfiguredFeature)TreeFeatures.f_195127_.m_203334_());
        this.addFungus(Items.f_41954_, (ConfiguredFeature)TreeFeatures.f_195117_.m_203334_(), new String[]{"crimson"});
        this.addFungus(Items.f_41955_, (ConfiguredFeature)TreeFeatures.f_195119_.m_203334_(), new String[]{"warped"});
        this.addMushroom(Items.f_41953_, (ConfiguredFeature)TreeFeatures.f_195122_.m_203334_(), new String[]{"mycelium"});
        this.addMushroom(Items.f_41952_, (ConfiguredFeature)TreeFeatures.f_195121_.m_203334_(), new String[]{"mycelium"});
        this.addCoral(Items.f_42291_, Items.f_42295_, Blocks.f_50585_);
        this.addCoral(Items.f_42292_, Items.f_42296_, Blocks.f_50586_);
        this.addCoral(Items.f_42293_, Items.f_42297_, Blocks.f_50587_);
        this.addCoral(Items.f_42294_, Items.f_42298_, Blocks.f_50588_);
        this.addCoral(Items.f_42290_, Items.f_42299_, Blocks.f_50584_);
        this.addChorus();
    }

    public JsonObject setTicks(JsonObject original, int ticks) {
        original.addProperty("ticks", (Number)ticks);
        return original;
    }

    public static SaplingDrop fruitDrop(Item item) {
        return new SaplingDrop(item, 0.05f, 1, false, true, Ingredient.f_43901_);
    }

    public ConfiguredFeature<TreeConfiguration, ?> getAsTreeConfiguration(ConfiguredFeature<?, ?> feature) {
        return feature;
    }

    private JsonObject addChorus() {
        Item chorusItem = Items.f_42730_;
        Item enderPeal = Items.f_42584_;
        Item chorusFlower = Items.f_42003_;
        JsonObject root = new JsonObject();
        root.addProperty("type", "bonsaitrees3:sapling");
        root.addProperty("mod", "minecraft");
        JsonObject saplingObject = new JsonObject();
        saplingObject.addProperty("item", chorusItem.getRegistryName().toString());
        root.add("sapling", (JsonElement)saplingObject);
        JsonArray drops = new JsonArray();
        this.addDrop(drops, chorusItem, 1, (double)0.2f);
        this.addDrop(drops, chorusFlower, 1, (double)0.1f);
        this.addDrop(drops, enderPeal, 1, (double)0.01f, true);
        root.add("drops", (JsonElement)drops);
        JsonArray tags = new JsonArray();
        tags.add("end_stone");
        root.add("compatibleSoilTags", (JsonElement)tags);
        this.setTicks(root, 6000);
        this.add("recipes/sapling/minecraft/chorus", root);
        return root;
    }

    private JsonObject addCoral(Item coralItem, Item deadCoralItem, Block coralBlock) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "bonsaitrees3:sapling");
        root.addProperty("mod", "minecraft");
        JsonObject saplingObject = new JsonObject();
        saplingObject.addProperty("item", coralItem.getRegistryName().toString());
        root.add("sapling", (JsonElement)saplingObject);
        JsonArray drops = new JsonArray();
        this.addDrop(drops, deadCoralItem, 1, (double)0.05f);
        this.addDrop(drops, coralItem, 1, (double)0.05f, true);
        this.addDrop(drops, coralBlock, 1, 0.75, true);
        root.add("drops", (JsonElement)drops);
        JsonArray tags = new JsonArray();
        tags.add("water");
        root.add("compatibleSoilTags", (JsonElement)tags);
        this.setTicks(root, 300);
        ResourceLocation coralLocation = coralItem.getRegistryName();
        this.add("recipes/sapling/" + coralLocation.m_135827_() + "/" + coralLocation.m_135815_(), root);
        return root;
    }

    private JsonObject addMushroom(Item mushroomItem, ConfiguredFeature<?, ?> mushroomFeature, String[] compatibleTags) {
        HugeMushroomFeatureConfiguration mc = (HugeMushroomFeatureConfiguration)mushroomFeature.f_65378_();
        JsonObject root = new JsonObject();
        root.addProperty("type", "bonsaitrees3:sapling");
        root.addProperty("mod", "minecraft");
        JsonObject saplingObject = new JsonObject();
        saplingObject.addProperty("item", mushroomItem.getRegistryName().toString());
        root.add("sapling", (JsonElement)saplingObject);
        JsonArray drops = new JsonArray();
        this.addDrop(drops, mushroomItem, 3, (double)0.2f);
        this.addDrop(drops, mc.f_67741_.m_7112_(null, null).m_60734_(), 1, 0.75, true);
        this.addDrop(drops, mc.f_67740_.m_7112_(null, null).m_60734_(), 2, (double)0.2f, true);
        root.add("drops", (JsonElement)drops);
        if (compatibleTags.length > 0) {
            JsonArray tags = new JsonArray();
            Arrays.stream(compatibleTags).forEach(s -> tags.add(s));
            root.add("compatibleSoilTags", (JsonElement)tags);
        }
        this.setTicks(root, 300);
        ResourceLocation mushroomLocation = ((ResourceKey)BuiltinRegistries.f_123861_.m_7854_(mushroomFeature).get()).m_135782_();
        this.add("recipes/sapling/" + mushroomLocation.m_135827_() + "/" + mushroomLocation.m_135815_(), root);
        return root;
    }

    private JsonObject addFungus(Item fungusItem, ConfiguredFeature<HugeFungusConfiguration, ?> fungusFeature, String[] compatibleTags) {
        HugeFungusConfiguration fc = (HugeFungusConfiguration)fungusFeature.f_65378_();
        JsonObject root = new JsonObject();
        root.addProperty("type", "bonsaitrees3:sapling");
        root.addProperty("mod", "minecraft");
        JsonObject saplingObject = new JsonObject();
        saplingObject.addProperty("item", fungusItem.getRegistryName().toString());
        root.add("sapling", (JsonElement)saplingObject);
        JsonArray drops = new JsonArray();
        this.addDrop(drops, fungusItem, 3, (double)0.2f);
        this.addDrop(drops, fc.f_65898_.m_60734_(), 1, 0.75);
        this.addDrop(drops, fc.f_65899_.m_60734_(), 2, (double)0.2f);
        this.addDrop(drops, fc.f_65900_.m_60734_(), 1, (double)0.05f);
        root.add("drops", (JsonElement)drops);
        if (compatibleTags.length > 0) {
            JsonArray tags = new JsonArray();
            Arrays.stream(compatibleTags).forEach(s -> tags.add(s));
            root.add("compatibleSoilTags", (JsonElement)tags);
        }
        this.setTicks(root, 400);
        ResourceLocation fungusLocation = ((ResourceKey)BuiltinRegistries.f_123861_.m_7854_(fungusFeature).get()).m_135782_();
        this.add("recipes/sapling/" + fungusLocation.m_135827_() + "/" + fungusLocation.m_135815_(), root);
        return root;
    }

    public JsonObject addSapling(Item saplingItem, ConfiguredFeature<TreeConfiguration, ?> treeFeature) {
        return this.addSapling(saplingItem, treeFeature, new String[]{"dirt", "grass"});
    }

    public JsonObject addSapling(Item saplingItem, ConfiguredFeature<TreeConfiguration, ?> treeFeature, SaplingDrop ... extraDrops) {
        return this.addSapling(saplingItem, treeFeature, new String[]{"dirt", "grass"}, extraDrops);
    }

    public JsonObject addSapling(Item saplingItem, ConfiguredFeature<TreeConfiguration, ?> treeFeature, String[] compatibleTags) {
        return this.addSapling(saplingItem, treeFeature, compatibleTags, null);
    }

    public JsonObject addSapling(Item saplingItem, ConfiguredFeature<TreeConfiguration, ?> treeFeature, String[] compatibleTags, SaplingDrop ... extraDrops) {
        Double chance;
        TreeConfiguration tc = (TreeConfiguration)treeFeature.f_65378_();
        JsonObject root = new JsonObject();
        root.addProperty("type", "bonsaitrees3:sapling");
        String mod = ((ResourceKey)BuiltinRegistries.f_123861_.m_7854_(treeFeature).get()).m_135782_().m_135827_();
        root.addProperty("mod", mod);
        JsonObject saplingObject = new JsonObject();
        saplingObject.addProperty("item", saplingItem.getRegistryName().toString());
        root.add("sapling", (JsonElement)saplingObject);
        JsonArray drops = new JsonArray();
        this.addDrop(drops, saplingItem, 1, (double)0.05f);
        for (Pair<BlockState, Double> trunkState : this.getProviderBlockStates(tc.f_68185_)) {
            Item trunkItem = ((BlockState)trunkState.getFirst()).m_60734_().m_5456_();
            chance = (Double)trunkState.getSecond();
            this.addDrop(drops, trunkItem, 1, 0.75 * chance);
        }
        this.addDrop(drops, Items.f_42398_, 3, (double)0.2f);
        for (Pair<BlockState, Double> foliageState : this.getProviderBlockStates(tc.f_161213_)) {
            Item foliageItem = ((BlockState)foliageState.getFirst()).m_60734_().m_5456_();
            chance = (Double)foliageState.getSecond();
            this.addDrop(drops, foliageItem, 2, (double)0.2f * chance, true);
        }
        if (extraDrops != null) {
            for (SaplingDrop drop : extraDrops) {
                this.addDrop(drops, drop);
            }
        }
        root.add("drops", (JsonElement)drops);
        if (compatibleTags.length > 0) {
            JsonArray tags = new JsonArray();
            Arrays.stream(compatibleTags).forEach(arg_0 -> ((JsonArray)tags).add(arg_0));
            root.add("compatibleSoilTags", (JsonElement)tags);
        }
        ResourceLocation treeLocation = ((ResourceKey)BuiltinRegistries.f_123861_.m_7854_(treeFeature).get()).m_135782_();
        this.add("recipes/sapling/" + treeLocation.m_135827_() + "/" + treeLocation.m_135815_(), root);
        return root;
    }

    public void addDrop(JsonArray drops, SaplingDrop drop) {
        JsonObject root = new JsonObject();
        root.addProperty("rolls", (Number)drop.rolls);
        root.addProperty("chance", (Number)Float.valueOf(DatagenSaplings.getRounded((double)drop.chance)));
        root.add("result", (JsonElement)new Ingredient.ItemValue(drop.resultStack).m_6544_());
        if (drop.requiresSilkTouch) {
            root.addProperty("requiresSilkTouch", Boolean.valueOf(true));
        }
        if (drop.requiresBees) {
            root.addProperty("requiresBees", Boolean.valueOf(true));
        }
        drops.add((JsonElement)root);
    }

    public void addDrop(JsonArray drops, Block drop, int rolls, double chance) {
        this.addDrop(drops, new ItemStack((ItemLike)drop), rolls, chance, false, false);
    }

    public void addDrop(JsonArray drops, Block drop, int rolls, double chance, boolean requiresSilkTouch) {
        this.addDrop(drops, new ItemStack((ItemLike)drop), rolls, chance, requiresSilkTouch, false);
    }

    public void addDrop(JsonArray drops, Block drop, int rolls, double chance, boolean requiresSilkTouch, boolean requiresBees) {
        this.addDrop(drops, new ItemStack((ItemLike)drop), rolls, chance, requiresSilkTouch, requiresBees);
    }

    public void addDrop(JsonArray drops, Item drop, int rolls, double chance) {
        this.addDrop(drops, new ItemStack((ItemLike)drop), rolls, chance, false, false);
    }

    public void addDrop(JsonArray drops, Item drop, int rolls, double chance, boolean requiresSilkTouch) {
        this.addDrop(drops, new ItemStack((ItemLike)drop), rolls, chance, requiresSilkTouch, false);
    }

    public void addDrop(JsonArray drops, Item drop, int rolls, double chance, boolean requiresSilkTouch, boolean requiresBees) {
        this.addDrop(drops, new ItemStack((ItemLike)drop), rolls, chance, requiresSilkTouch, requiresBees);
    }

    public void addDrop(JsonArray drops, ItemStack drop, int rolls, double chance, boolean requiresSilkTouch, boolean requiresBees) {
        if (drop.m_41619_()) {
            return;
        }
        JsonObject root = new JsonObject();
        root.addProperty("rolls", (Number)rolls);
        root.addProperty("chance", (Number)Float.valueOf(DatagenSaplings.getRounded((double)chance)));
        root.add("result", (JsonElement)new Ingredient.ItemValue(drop).m_6544_());
        if (requiresSilkTouch) {
            root.addProperty("requiresSilkTouch", Boolean.valueOf(true));
        }
        if (requiresBees) {
            root.addProperty("requiresBees", Boolean.valueOf(true));
        }
        drops.add((JsonElement)root);
    }

    private List<Pair<BlockState, Double>> getProviderBlockStates(BlockStateProvider provider) {
        if (provider instanceof SimpleStateProvider) {
            SimpleStateProvider ssp = (SimpleStateProvider)provider;
            return List.of(Pair.of((Object)ssp.m_7112_(null, null), (Object)1.0));
        }
        if (provider instanceof WeightedStateProvider) {
            WeightedStateProvider wsp = (WeightedStateProvider)provider;
            SimpleWeightedRandomList weightedList = BlockStateProviderReflection.getWeightedListFromWeightedStateProvider(BlockState.class, (WeightedStateProvider)wsp);
            int totalWeight = WeightedRandom.m_146312_((List)weightedList.m_146338_());
            if (totalWeight <= 0) {
                return Collections.emptyList();
            }
            ArrayList<Pair<BlockState, Double>> result = new ArrayList<Pair<BlockState, Double>>();
            for (WeightedEntry.Wrapper entry : weightedList.m_146338_()) {
                double chance = (double)entry.m_142631_().m_146281_() / (double)totalWeight;
                result.add((Pair<BlockState, Double>)Pair.of((Object)((BlockState)entry.m_146310_()).m_60734_().m_49966_(), (Object)chance));
            }
            return result;
        }
        LOGGER.error("Unknown block state provider {}. Skipping some blocks in recipe drops!", (Object)provider);
        return Collections.emptyList();
    }

    public String m_6055_() {
        return "Bonsai Trees Sapling Types";
    }
}

