/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.compat.jei;

import com.davenonymous.bonsaitrees3.BonsaiTrees3;
import com.davenonymous.bonsaitrees3.blocks.BonsaiPotContainer;
import com.davenonymous.bonsaitrees3.client.BonsaiPotScreen;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiRecipeCategory;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiRecipeWrapper;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiUpgradeCategory;
import com.davenonymous.bonsaitrees3.compat.jei.BonsaiUpgradeWrapper;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.setup.Registration;
import com.davenonymous.libnonymous.helper.EnchantmentHelper;
import com.davenonymous.libnonymous.helper.Translatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class BonsaiTreesJEIPlugin
implements IModPlugin {
    public static List<SaplingInfo> saplings;
    private static final ResourceLocation PLUGIN_ID;
    public static final Translatable UPGRADE_TEXT_HOPPING;
    public static final Translatable UPGRADE_TEXT_AUTOCUT;
    public static final Translatable UPGRADE_TEXT_FORTUNE;
    public static final Translatable UPGRADE_TEXT_EFFICIENCY;
    public static final Translatable UPGRADE_TEXT_SILKTOUCH;
    public static final Translatable UPGRADE_TEXT_BEES;

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BONSAI_POT.get()), new ResourceLocation[]{BonsaiRecipeCategory.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BONSAI_POT.get()), new ResourceLocation[]{BonsaiUpgradeCategory.ID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(BonsaiPotScreen.class, 29, 19, BonsaiPotContainer.WIDTH - 116, 18, new ResourceLocation[]{BonsaiRecipeCategory.ID, BonsaiUpgradeCategory.ID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (saplings == null) {
            return;
        }
        BonsaiTrees3.LOGGER.info("Registering {} saplings", (Object)saplings.size());
        registration.addRecipes(BonsaiTreesJEIPlugin.asRecipes(saplings, BonsaiRecipeWrapper::new), BonsaiRecipeCategory.ID);
        ArrayList<ItemStack> axeItems = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack stack2;
            if (!item.canPerformAction(stack2 = new ItemStack((ItemLike)item), ToolActions.AXE_DIG)) continue;
            axeItems.add(stack2);
        }
        ArrayList<ItemStack> fortuneItems = new ArrayList<ItemStack>();
        fortuneItems.addAll(EnchantmentHelper.getEnchantmentBooks((Enchantment)Enchantments.f_44987_));
        fortuneItems.addAll(axeItems.stream().map(ItemStack::m_41777_).peek(stack -> stack.m_41663_(Enchantments.f_44987_, 1)).toList());
        ArrayList<ItemStack> efficiencyItems = new ArrayList<ItemStack>();
        efficiencyItems.addAll(EnchantmentHelper.getEnchantmentBooks((Enchantment)Enchantments.f_44984_));
        efficiencyItems.addAll(axeItems.stream().map(ItemStack::m_41777_).peek(stack -> stack.m_41663_(Enchantments.f_44984_, 1)).toList());
        ArrayList<ItemStack> silkTouchItems = new ArrayList<ItemStack>();
        silkTouchItems.addAll(EnchantmentHelper.getEnchantmentBooks((Enchantment)Enchantments.f_44985_));
        silkTouchItems.addAll(axeItems.stream().map(ItemStack::m_41777_).peek(stack -> stack.m_41663_(Enchantments.f_44985_, 1)).toList());
        ArrayList<ItemStack> beeItems = new ArrayList<ItemStack>();
        beeItems.add(new ItemStack((ItemLike)Blocks.f_50718_));
        beeItems.add(new ItemStack((ItemLike)Blocks.f_50717_));
        List<BonsaiUpgradeWrapper> upgradeRecipes = List.of(new BonsaiUpgradeWrapper(UPGRADE_TEXT_HOPPING, new ItemStack((ItemLike)Blocks.f_50332_)), new BonsaiUpgradeWrapper(UPGRADE_TEXT_AUTOCUT, axeItems), new BonsaiUpgradeWrapper(UPGRADE_TEXT_FORTUNE, fortuneItems), new BonsaiUpgradeWrapper(UPGRADE_TEXT_EFFICIENCY, efficiencyItems), new BonsaiUpgradeWrapper(UPGRADE_TEXT_SILKTOUCH, silkTouchItems), new BonsaiUpgradeWrapper(UPGRADE_TEXT_BEES, beeItems));
        registration.addRecipes(upgradeRecipes, BonsaiUpgradeCategory.ID);
    }

    private static <T, R> Collection<R> asRecipes(Collection<T> collection, Function<T, R> transformer) {
        return collection.stream().map(transformer).collect(Collectors.toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        BonsaiRecipeWrapper.tickTimer = registration.getJeiHelpers().getGuiHelper().createTickTimer(360, 360, false);
        registration.addRecipeCategories(new IRecipeCategory[]{new BonsaiRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BonsaiUpgradeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    static {
        PLUGIN_ID = new ResourceLocation("bonsaitrees3", "jei");
        UPGRADE_TEXT_HOPPING = new Translatable("bonsaitrees3", "jei.upgrade.hopper");
        UPGRADE_TEXT_AUTOCUT = new Translatable("bonsaitrees3", "jei.upgrade.autocut");
        UPGRADE_TEXT_FORTUNE = new Translatable("bonsaitrees3", "jei.upgrade.fortune");
        UPGRADE_TEXT_EFFICIENCY = new Translatable("bonsaitrees3", "jei.upgrade.efficiency");
        UPGRADE_TEXT_SILKTOUCH = new Translatable("bonsaitrees3", "jei.upgrade.silktouch");
        UPGRADE_TEXT_BEES = new Translatable("bonsaitrees3", "jei.upgrade.bees");
    }
}

