/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.mods.myrtrees.common.block;

import io.alwa.mods.myrtrees.common.blockentity.FilledRubberwoodLogBlockEntity;
import io.alwa.mods.myrtrees.common.blockentity.TreeTapBlockEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TreeTapBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)13.0, (double)-1.0, (double)6.0, (double)16.0, (double)4.0, (double)10.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)-1.0, (double)6.0, (double)3.0, (double)4.0, (double)10.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)6.0, (double)-1.0, (double)13.0, (double)10.0, (double)4.0, (double)16.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)6.0, (double)-1.0, (double)0.0, (double)10.0, (double)4.0, (double)3.0);
    public static final BooleanProperty FLOWING = BooleanProperty.m_61465_((String)"flowing");

    public TreeTapBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50332_));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        if (blockPlaceContext.m_43719_().m_122434_() == Direction.Axis.Y) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)blockPlaceContext.m_43719_().m_122424_())).m_61124_((Property)FLOWING, (Comparable)Boolean.valueOf(false));
    }

    private boolean canAttachTo(BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        return blockGetter.m_7702_(blockPos) instanceof FilledRubberwoodLogBlockEntity;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return !this.m_7898_(blockState, (LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.m_61143_((Property)f_54117_);
        return this.canAttachTo((BlockGetter)levelReader, blockPos.m_142300_(direction), direction);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((Direction)blockState.m_61143_((Property)f_54117_)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            default -> SHAPE_NORTH;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, FLOWING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState blockState, Level level, BlockPos blockPos, Random random) {
        if (((Boolean)blockState.m_61143_((Property)FLOWING)).booleanValue()) {
            Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
            double x = (double)blockPos.m_123341_() + 0.5 + (double)facing.m_122429_() * 0.3;
            double y = (double)blockPos.m_123342_() - 0.1;
            double z = (double)blockPos.m_123343_() + 0.5 + (double)facing.m_122431_() * 0.3;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TreeTapBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.m_5776_() ? null : TreeTapBlockEntity::tick;
    }
}

