/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class MultiItemHandler
implements IItemHandler {
    private List<LazyOptional<IItemHandler>> handlers = new ArrayList<LazyOptional<IItemHandler>>();
    private List<ItemStack[]> dupDetector = new ArrayList<ItemStack[]>();
    private int[] invSizes = new int[0];
    private int invSize;
    private boolean calling;

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.calling) {
            return false;
        }
        if (slot >= this.invSize) {
            return false;
        }
        this.calling = true;
        for (int i = 0; i < this.invSizes.length; ++i) {
            if (slot >= this.invSizes[i]) {
                slot -= this.invSizes[i];
                continue;
            }
            boolean r = ((IItemHandler)this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).isItemValid(slot, stack);
            this.calling = false;
            return r;
        }
        this.calling = false;
        return false;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.calling) {
            return stack;
        }
        if (slot >= this.invSize) {
            return stack;
        }
        this.calling = true;
        for (int i = 0; i < this.invSizes.length; ++i) {
            if (slot >= this.invSizes[i]) {
                slot -= this.invSizes[i];
                continue;
            }
            ItemStack s = ((IItemHandler)this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).insertItem(slot, stack, simulate);
            this.calling = false;
            return s;
        }
        this.calling = false;
        return stack;
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.calling) {
            return ItemStack.f_41583_;
        }
        if (slot >= this.invSize) {
            return ItemStack.f_41583_;
        }
        this.calling = true;
        for (int i = 0; i < this.invSizes.length; ++i) {
            if (slot >= this.invSizes[i]) {
                slot -= this.invSizes[i];
                continue;
            }
            ItemStack s = ((IItemHandler)this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).getStackInSlot(slot);
            this.calling = false;
            return s;
        }
        this.calling = false;
        return ItemStack.f_41583_;
    }

    public int getSlots() {
        return this.invSize;
    }

    public int getSlotLimit(int slot) {
        if (this.calling) {
            return 0;
        }
        if (slot >= this.invSize) {
            return 0;
        }
        this.calling = true;
        for (int i = 0; i < this.invSizes.length; ++i) {
            if (slot >= this.invSizes[i]) {
                slot -= this.invSizes[i];
                continue;
            }
            int r = ((IItemHandler)this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).getSlotLimit(slot);
            this.calling = false;
            return r;
        }
        this.calling = false;
        return 0;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.calling) {
            return ItemStack.f_41583_;
        }
        if (slot >= this.invSize) {
            return ItemStack.f_41583_;
        }
        this.calling = true;
        for (int i = 0; i < this.invSizes.length; ++i) {
            if (slot >= this.invSizes[i]) {
                slot -= this.invSizes[i];
                continue;
            }
            ItemStack s = ((IItemHandler)this.handlers.get(i).orElse((Object)EmptyHandler.INSTANCE)).extractItem(slot, amount, simulate);
            this.calling = false;
            return s;
        }
        this.calling = false;
        return ItemStack.f_41583_;
    }

    public List<LazyOptional<IItemHandler>> getHandlers() {
        return this.handlers;
    }

    public void refresh() {
        this.dupDetector.clear();
        if (this.invSizes.length != this.handlers.size()) {
            this.invSizes = new int[this.handlers.size()];
        }
        this.invSize = 0;
        for (int i = 0; i < this.invSizes.length; ++i) {
            int s;
            IItemHandler ih = (IItemHandler)this.handlers.get(i).orElse(null);
            if (ih == null) {
                this.invSizes[i] = 0;
                continue;
            }
            this.invSizes[i] = s = ih.getSlots();
            this.invSize += s;
        }
    }

    public boolean contains(Object o) {
        return this.handlers.contains(o);
    }

    public void add(LazyOptional<IItemHandler> e) {
        if (e.map(this::checkInv).orElse(false).booleanValue()) {
            this.handlers.add(e);
        }
    }

    private boolean checkInv(IItemHandler h) {
        int len = Math.min(Config.invDupScanSize, h.getSlots());
        if (len == 0) {
            return true;
        }
        ItemStack[] is = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            is[i] = h.getStackInSlot(i);
        }
        for (ItemStack[] st : this.dupDetector) {
            int l = Math.min(len, st.length);
            for (int i = 0; i < l; ++i) {
                ItemStack item = st[i];
                if (item.m_41619_() || item != is[i]) continue;
                return false;
            }
        }
        this.dupDetector.add(is);
        return true;
    }

    public void clear() {
        this.invSize = 0;
        this.handlers.clear();
        this.dupDetector.clear();
    }
}

