/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.TickerUtil;
import com.tom.storagemod.block.StorageTerminalBase;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.tile.TileEntityInventoryCableConnector;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityStorageTerminal
extends BlockEntity
implements MenuProvider,
TickerUtil.TickableServer {
    private IItemHandler itemHandler;
    private Map<StoredItemStack, Long> items = new HashMap<StoredItemStack, Long>();
    private int sort;
    private String lastSearch = "";
    private boolean updateItems;
    private int beaconLevel;

    public TileEntityStorageTerminal(BlockPos pos, BlockState state) {
        super(StorageMod.terminalTile, pos, state);
    }

    public TileEntityStorageTerminal(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory plInv, Player arg2) {
        return new ContainerStorageTerminal(id, plInv, this);
    }

    public Component m_5446_() {
        return new TranslatableComponent("ts.storage_terminal");
    }

    public Map<StoredItemStack, Long> getStacks() {
        this.updateItems = true;
        return this.items;
    }

    public StoredItemStack pullStack(StoredItemStack stack, long max) {
        if (stack != null && this.itemHandler != null && max > 0L) {
            ItemStack st = stack.getStack();
            StoredItemStack ret = null;
            for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
                ItemStack pulled;
                ItemStack s = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.m_41746_((ItemStack)s, (ItemStack)st) || !ItemStack.m_41658_((ItemStack)s, (ItemStack)st) || (pulled = this.itemHandler.extractItem(i, (int)max, false)).m_41619_()) continue;
                if (ret == null) {
                    ret = new StoredItemStack(pulled);
                } else {
                    ret.grow(pulled.m_41613_());
                }
                if ((max -= (long)pulled.m_41613_()) < 1L) break;
            }
            return ret;
        }
        return null;
    }

    public StoredItemStack pushStack(StoredItemStack stack) {
        if (stack != null && this.itemHandler != null) {
            ItemStack is = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)stack.getActualStack(), (boolean)false);
            if (is.m_41619_()) {
                return null;
            }
            return new StoredItemStack(is);
        }
        return stack;
    }

    public ItemStack pushStack(ItemStack itemstack) {
        StoredItemStack is = this.pushStack(new StoredItemStack(itemstack));
        return is == null ? ItemStack.f_41583_ : is.getActualStack();
    }

    public void pushOrDrop(ItemStack st) {
        if (st.m_41619_()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st));
        if (st0 != null) {
            Containers.m_18992_((Level)this.f_58857_, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), (ItemStack)st0.getActualStack());
        }
    }

    @Override
    public void updateServer() {
        if (this.updateItems) {
            BlockState st = this.f_58857_.m_8055_(this.f_58858_);
            Direction d = (Direction)st.m_61143_((Property)StorageTerminalBase.FACING);
            StorageTerminalBase.TerminalPos p2 = (StorageTerminalBase.TerminalPos)((Object)st.m_61143_(StorageTerminalBase.TERMINAL_POS));
            if (p2 == StorageTerminalBase.TerminalPos.UP) {
                d = Direction.UP;
            }
            if (p2 == StorageTerminalBase.TerminalPos.DOWN) {
                d = Direction.DOWN;
            }
            BlockEntity invTile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(d));
            this.items.clear();
            if (invTile != null) {
                LazyOptional lih = invTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.m_122424_());
                this.itemHandler = (IItemHandler)lih.orElse(null);
                if (this.itemHandler != null) {
                    IntStream.range(0, this.itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)this.itemHandler).getStackInSlot(arg_0)).filter(s -> !s.m_41619_()).map(StoredItemStack::new).forEach(s -> this.items.merge((StoredItemStack)s, s.getQuantity(), (a, b) -> a + b));
                }
            }
            this.updateItems = false;
        }
        if (this.f_58857_.m_46467_() % 40L == 5L) {
            this.beaconLevel = BlockPos.m_121921_((AABB)new AABB(this.f_58858_).m_82400_(8.0)).mapToInt(p -> {
                BlockState st;
                if (this.f_58857_.m_46749_(p) && (st = this.f_58857_.m_8055_(p)).m_60713_(Blocks.f_50273_)) {
                    return TileEntityInventoryCableConnector.calcBeaconLevel(this.f_58857_, p.m_123341_(), p.m_123342_(), p.m_123343_());
                }
                return 0;
            }).max().orElse(0);
        }
    }

    public boolean canInteractWith(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        int d = 4;
        int termReach = 0;
        if (player.m_21205_().m_41720_() instanceof WirelessTerminal) {
            termReach = Math.max(termReach, ((WirelessTerminal)player.m_21205_().m_41720_()).getRange(player, player.m_21205_()));
        }
        if (player.m_21206_().m_41720_() instanceof WirelessTerminal) {
            termReach = Math.max(termReach, ((WirelessTerminal)player.m_21206_().m_41720_()).getRange(player, player.m_21206_()));
        }
        if (this.beaconLevel >= Config.wirelessTermBeaconLvl && termReach > 0) {
            if (this.beaconLevel >= Config.wirelessTermBeaconLvlDim) {
                return true;
            }
            return player.m_183503_() == this.f_58857_;
        }
        d = Math.max(d, termReach);
        return player.m_183503_() == this.f_58857_ && !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > (double)(d * 2 * d * 2));
    }

    public int getSorting() {
        return this.sort;
    }

    public void setSorting(int newC) {
        this.sort = newC;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("sort", this.sort);
    }

    public void m_142466_(CompoundTag compound) {
        this.sort = compound.m_128451_("sort");
        super.m_142466_(compound);
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void setLastSearch(String string) {
        this.lastSearch = string;
    }
}

