/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.TickerUtil;
import com.tom.storagemod.block.BlockInventoryCableConnector;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.tile.TileEntityInventoryConnector;
import com.tom.storagemod.tile.TileEntityPainted;
import com.tom.storagemod.util.IProxy;
import java.util.HashSet;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityInventoryCableConnectorBase
extends TileEntityPainted
implements TickerUtil.TickableServer {
    protected TileEntityInventoryConnector master;
    protected LazyOptional<IItemHandler> invHandler;
    protected LazyOptional<IItemHandler> pointedAt;
    protected TileEntityInventoryConnector.LinkedInv linv;

    public TileEntityInventoryCableConnectorBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void updateServer() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 19L) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Direction facing = (Direction)state.m_61143_((Property)BlockInventoryCableConnector.FACING);
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            checkedBlocks.add(this.f_58858_);
            toCheck.addAll(((IInventoryCable)state.m_60734_()).next(this.f_58857_, state, this.f_58858_));
            if (this.master != null) {
                this.master.unLink(this.linv);
            }
            this.master = null;
            this.linv = new TileEntityInventoryConnector.LinkedInv();
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                if (checkedBlocks.contains(cp)) continue;
                checkedBlocks.add(cp);
                if (this.f_58857_.m_46749_(cp)) {
                    state = this.f_58857_.m_8055_(cp);
                    if (state.m_60734_() == StorageMod.connector) {
                        BlockEntity te = this.f_58857_.m_7702_(cp);
                        if (!(te instanceof TileEntityInventoryConnector)) break;
                        this.master = (TileEntityInventoryConnector)te;
                        this.linv.time = this.f_58857_.m_46467_();
                        this.linv.handler = this::applyFilter;
                        this.master.addLinked(this.linv);
                        break;
                    }
                    if (state.m_60734_() instanceof IInventoryCable) {
                        toCheck.addAll(((IInventoryCable)state.m_60734_()).next(this.f_58857_, state, cp));
                    }
                }
                if (checkedBlocks.size() <= Config.invConnectorMax) continue;
                break;
            }
            this.pointedAt = this.getPointedAt(this.f_58858_.m_142300_(facing), facing);
        }
    }

    protected LazyOptional<IItemHandler> getPointedAt(BlockPos pos, Direction facing) {
        BlockEntity te = this.f_58857_.m_7702_(pos);
        if (te != null) {
            return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.m_122424_());
        }
        return null;
    }

    protected LazyOptional<IItemHandler> applyFilter() {
        return this.pointedAt == null ? LazyOptional.empty() : this.pointedAt;
    }

    protected LazyOptional<IItemHandler> makeCapability() {
        return LazyOptional.of(() -> new InvHandler());
    }

    protected LazyOptional<IItemHandler> getCapability() {
        if (this.invHandler == null) {
            this.invHandler = this.makeCapability();
        }
        return this.invHandler;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    private class InvHandler
    implements IItemHandler,
    IProxy {
        private boolean calling;

        private InvHandler() {
        }

        public <R> R call(Function<IItemHandler, R> func, R def) {
            if (this.calling) {
                return def;
            }
            this.calling = true;
            if (TileEntityInventoryCableConnectorBase.this.master != null && !TileEntityInventoryCableConnectorBase.this.master.m_58901_()) {
                R r = func.apply((IItemHandler)TileEntityInventoryCableConnectorBase.this.master.getInventory().orElse((Object)EmptyHandler.INSTANCE));
                this.calling = false;
                return r;
            }
            this.calling = false;
            return def;
        }

        public int getSlots() {
            return this.call(IItemHandler::getSlots, 0);
        }

        public ItemStack getStackInSlot(int slot) {
            return this.call(i -> i.getStackInSlot(slot), ItemStack.f_41583_);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.call(i -> i.insertItem(slot, stack, simulate), stack);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.call(i -> i.extractItem(slot, amount, simulate), ItemStack.f_41583_);
        }

        public int getSlotLimit(int slot) {
            return this.call(i -> i.getSlotLimit(slot), 0);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.call(i -> i.isItemValid(slot, stack), false);
        }

        @Override
        public IItemHandler get() {
            if (TileEntityInventoryCableConnectorBase.this.master != null && !TileEntityInventoryCableConnectorBase.this.master.m_58901_()) {
                return (IItemHandler)TileEntityInventoryCableConnectorBase.this.master.getInventory().orElse(null);
            }
            return null;
        }
    }
}

