/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.network;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.network.DataPacket;
import com.tom.storagemod.network.IDataReceiver;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("toms_storage", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, DataPacket.class, DataPacket::toBytes, DataPacket::new, NetworkHandler::handleData);
        StorageMod.LOGGER.info("Initilaized Network Handler");
    }

    public static void handleData(DataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.f_36096_ instanceof IDataReceiver) {
                    ((IDataReceiver)sender.f_36096_).receive(packet.tag);
                }
            });
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                if (Minecraft.m_91087_().f_91080_ instanceof IDataReceiver) {
                    ((IDataReceiver)Minecraft.m_91087_().f_91080_).receive(packet.tag);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static void sendDataToServer(CompoundTag tag) {
        INSTANCE.sendToServer((Object)new DataPacket(tag));
    }

    public static void sendTo(ServerPlayer pl, CompoundTag tag) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> pl), (Object)new DataPacket(tag));
    }
}

