/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.gui.ControllMode;
import com.tom.storagemod.gui.GuiCraftingTerminal;
import com.tom.storagemod.jei.JEIHandler;
import com.tom.storagemod.network.IDataReceiver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fml.ModList;
import org.lwjgl.glfw.GLFW;

public abstract class GuiStorageTerminalBase<T extends ContainerStorageTerminal>
extends AbstractContainerScreen<T>
implements IDataReceiver {
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<StoredItemStack, List<String>>(){

        public List<String> load(StoredItemStack key) throws Exception {
            return key.getStack().m_41651_((Player)Minecraft.m_91087_().f_91074_, GuiStorageTerminalBase.getTooltipFlag()).stream().map(Component::getString).collect(Collectors.toList());
        }
    });
    protected Minecraft mc = Minecraft.m_91087_();
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected EditBox searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    protected int searchType;
    private String searchLast = "";
    protected boolean loadedSearch = false;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    protected GuiButton buttonSortingType;
    protected GuiButton buttonDirection;
    protected GuiButton buttonSearchType;
    protected GuiButton buttonCtrlMode;
    private FakeSlot fakeSlotUnderMouse = new FakeSlot();

    public GuiStorageTerminalBase(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        ((ContainerStorageTerminal)screenContainer).onPacket = this::onPacket;
    }

    protected void onPacket() {
        int s = ((ContainerStorageTerminal)this.f_97732_).terminalData;
        this.controllMode = (s & 3) % ControllMode.VALUES.length;
        boolean rev = (s & 4) > 0;
        int type = (s & 0x18) >> 3;
        this.comparator = StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length].create(rev);
        this.searchType = (s & 0xE0) >> 5;
        if (!this.searchField.m_93696_() && (this.searchType & 1) > 0) {
            this.searchField.m_94178_(true);
        }
        this.buttonSortingType.state = type;
        this.buttonDirection.state = rev ? 1 : 0;
        this.buttonSearchType.state = this.searchType;
        this.buttonCtrlMode.state = this.controllMode;
        if (!this.loadedSearch && ((ContainerStorageTerminal)this.f_97732_).search != null) {
            this.loadedSearch = true;
            if ((this.searchType & 2) > 0) {
                this.searchField.m_94144_(((ContainerStorageTerminal)this.f_97732_).search);
            }
        }
    }

    protected void sendUpdate() {
        CompoundTag c = new CompoundTag();
        c.m_128405_("d", this.updateData());
        CompoundTag msg = new CompoundTag();
        msg.m_128365_("c", (Tag)c);
        ((ContainerStorageTerminal)this.f_97732_).sendMessage(msg);
    }

    protected int updateData() {
        int d = 0;
        d |= this.controllMode & 3;
        d |= (this.comparator.isReversed() ? 1 : 0) << 2;
        d |= this.comparator.type() << 3;
        return d |= (this.searchType & 7) << 5;
    }

    protected void m_7856_() {
        this.m_169413_();
        this.f_97731_ = this.f_97727_ - 92;
        super.m_7856_();
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        this.searchField = new EditBox(font, this.f_97735_ + 82, this.f_97736_ + 6, 89, 9, (Component)new TranslatableComponent("narrator.toms_storage.terminal_search"));
        this.searchField.m_94199_(100);
        this.searchField.m_94182_(false);
        this.searchField.m_94194_(true);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94144_(this.searchLast);
        this.searchLast = "";
        this.m_142416_((GuiEventListener)this.searchField);
        this.buttonSortingType = (GuiButton)this.m_142416_((GuiEventListener)new GuiButton(this.f_97735_ - 18, this.f_97736_ + 5, 0, b -> {
            this.comparator = StoredItemStack.SortingTypes.VALUES[(this.comparator.type() + 1) % StoredItemStack.SortingTypes.VALUES.length].create(this.comparator.isReversed());
            this.buttonSortingType.state = this.comparator.type();
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (GuiButton)this.m_142416_((GuiEventListener)new GuiButton(this.f_97735_ - 18, this.f_97736_ + 5 + 18, 1, b -> {
            this.comparator.setReversed(!this.comparator.isReversed());
            this.buttonDirection.state = this.comparator.isReversed() ? 1 : 0;
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (GuiButton)this.m_142416_((GuiEventListener)new GuiButton(this.f_97735_ - 18, this.f_97736_ + 5 + 36, 2, b -> {
            this.buttonSearchType.state = this.searchType = this.searchType + 1 & (ModList.get().isLoaded("jei") || this instanceof GuiCraftingTerminal ? 7 : 3);
            this.sendUpdate();
        }){

            @Override
            public void m_6303_(PoseStack st, int mouseX, int mouseY, float pt) {
                if (this.f_93624_) {
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)GuiStorageTerminalBase.this.getGui());
                    this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    this.m_93228_(st, this.f_93620_, this.f_93621_, this.texX, this.texY + this.tile * 16, this.f_93618_, this.f_93619_);
                    if ((this.state & 1) > 0) {
                        this.m_93228_(st, this.f_93620_ + 1, this.f_93621_ + 1, this.texX + 16, this.texY + this.tile * 16, this.f_93618_ - 2, this.f_93619_ - 2);
                    }
                    if ((this.state & 2) > 0) {
                        this.m_93228_(st, this.f_93620_ + 1, this.f_93621_ + 1, this.texX + 16 + 14, this.texY + this.tile * 16, this.f_93618_ - 2, this.f_93619_ - 2);
                    }
                    if ((this.state & 4) > 0) {
                        this.m_93228_(st, this.f_93620_ + 1, this.f_93621_ + 1, this.texX + 16 + 28, this.texY + this.tile * 16, this.f_93618_ - 2, this.f_93619_ - 2);
                    }
                }
            }
        });
        this.buttonCtrlMode = (GuiButton)this.m_142416_((GuiEventListener)new GuiButton(this.f_97735_ - 18, this.f_97736_ + 5 + 54, 3, b -> {
            this.buttonCtrlMode.state = this.controllMode = (this.controllMode + 1) % ControllMode.VALUES.length;
            this.sendUpdate();
        }));
        this.updateSearch();
    }

    protected void updateSearch() {
        String searchString = this.searchField.m_94155_();
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            ((ContainerStorageTerminal)this.m_6262_()).itemListClientSorted.clear();
            boolean searchMod = false;
            String search = searchString;
            if (searchString.startsWith("@")) {
                searchMod = true;
                search = searchString.substring(1);
            }
            Pattern m = null;
            try {
                m = Pattern.compile(search.toLowerCase(), 2);
            }
            catch (Throwable ignore) {
                try {
                    m = Pattern.compile(Pattern.quote(search.toLowerCase()), 2);
                }
                catch (Throwable __) {
                    return;
                }
            }
            boolean notDone = false;
            try {
                block6: for (int i = 0; i < ((ContainerStorageTerminal)this.m_6262_()).itemListClient.size(); ++i) {
                    StoredItemStack is = ((ContainerStorageTerminal)this.m_6262_()).itemListClient.get(i);
                    if (is == null || is.getStack() == null) continue;
                    String dspName = searchMod ? is.getStack().m_41720_().delegate.name().m_135827_() : is.getStack().m_41786_().getString();
                    notDone = true;
                    if (m.matcher(dspName.toLowerCase()).find()) {
                        this.addStackToClientList(is);
                        notDone = false;
                    }
                    if (!notDone) continue;
                    for (String lp : (List)tooltipCache.get((Object)is)) {
                        if (!m.matcher(lp).find()) continue;
                        this.addStackToClientList(is);
                        notDone = false;
                        continue block6;
                    }
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            Collections.sort(((ContainerStorageTerminal)this.m_6262_()).itemListClientSorted, this.comparator);
            if (!this.searchLast.equals(searchString)) {
                ((ContainerStorageTerminal)this.m_6262_()).scrollTo(0.0f);
                this.currentScroll = 0.0f;
                if ((this.searchType & 4) > 0 && ModList.get().isLoaded("jei")) {
                    JEIHandler.setJeiSearchText(searchString);
                }
                if ((this.searchType & 2) > 0) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128359_("s", searchString);
                    ((ContainerStorageTerminal)this.f_97732_).sendMessage(nbt);
                }
                this.onUpdateSearch(searchString);
            } else {
                ((ContainerStorageTerminal)this.m_6262_()).scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        ((ContainerStorageTerminal)this.m_6262_()).itemListClientSorted.add(is);
    }

    public static TooltipFlag getTooltipFlag() {
        return Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
    }

    protected void m_181908_() {
        this.updateSearch();
    }

    public void m_6305_(PoseStack st, int mouseX, int mouseY, float partialTicks) {
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) != 0;
        int i = this.f_97735_;
        int j = this.f_97736_;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerStorageTerminal)this.m_6262_()).scrollTo(this.currentScroll);
        }
        super.m_6305_(st, mouseX, mouseY, partialTicks);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)creativeInventoryTabs);
        i = k;
        j = l;
        k = j1;
        this.m_93228_(st, i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        st.m_85836_();
        this.slotIDUnderMouse = this.drawSlots(st, mouseX, mouseY);
        st.m_85849_();
        this.m_7025_(st, mouseX, mouseY);
        if (this.buttonSortingType.m_198029_()) {
            this.m_96602_(st, (Component)new TranslatableComponent("tooltip.toms_storage.sorting_" + this.buttonSortingType.state), mouseX, mouseY);
        }
        if (this.buttonSearchType.m_198029_()) {
            this.m_96602_(st, (Component)new TranslatableComponent("tooltip.toms_storage.search_" + this.buttonSearchType.state, new Object[]{"JEI"}), mouseX, mouseY);
        }
        if (this.buttonCtrlMode.m_198029_()) {
            this.m_96597_(st, Arrays.stream(I18n.m_118938_((String)("tooltip.toms_storage.ctrlMode_" + this.buttonCtrlMode.state), (Object[])new Object[0]).split("\\\\")).map(TextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    protected int drawSlots(PoseStack st, int mouseX, int mouseY) {
        int i;
        ContainerStorageTerminal term = (ContainerStorageTerminal)this.m_6262_();
        for (i = 0; i < term.storageSlotList.size(); ++i) {
            this.drawSlot(st, term.storageSlotList.get(i), mouseX, mouseY);
        }
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        st.m_85836_();
        st.m_85837_(0.0, 0.0, 100.0);
        for (i = 0; i < term.storageSlotList.size(); ++i) {
            if (!this.drawTooltip(st, term.storageSlotList.get(i), mouseX, mouseY)) continue;
            st.m_85849_();
            return i;
        }
        st.m_85849_();
        return -1;
    }

    protected void drawSlot(PoseStack st, ContainerStorageTerminal.SlotStorage slot, int mouseX, int mouseY) {
        if (mouseX >= this.getGuiLeft() + slot.xDisplayPosition - 1 && mouseY >= this.getGuiTop() + slot.yDisplayPosition - 1 && mouseX < this.getGuiLeft() + slot.xDisplayPosition + 17 && mouseY < this.getGuiTop() + slot.yDisplayPosition + 17) {
            int l = this.getGuiLeft() + slot.xDisplayPosition;
            int t = this.getGuiTop() + slot.yDisplayPosition;
            GuiStorageTerminalBase.m_93172_((PoseStack)st, (int)l, (int)t, (int)(l + 16), (int)(t + 16), (int)-2130706433);
        }
        if (slot.stack != null) {
            st.m_85836_();
            this.renderItemInGui(st, slot.stack.getStack().m_41777_().m_41620_(1), this.getGuiLeft() + slot.xDisplayPosition, this.getGuiTop() + slot.yDisplayPosition, 0, 0, false, 0xFFFFFF, false, new String[0]);
            Font r = this.getFont();
            this.drawStackSize(st, r, slot.stack.getQuantity(), this.getGuiLeft() + slot.xDisplayPosition, this.getGuiTop() + slot.yDisplayPosition);
            st.m_85849_();
        }
    }

    protected boolean drawTooltip(PoseStack st, ContainerStorageTerminal.SlotStorage slot, int mouseX, int mouseY) {
        if (slot.stack != null) {
            if (slot.stack.getQuantity() > 9999L) {
                this.renderItemInGui(st, slot.stack.getStack(), this.getGuiLeft() + slot.xDisplayPosition, this.getGuiTop() + slot.yDisplayPosition, mouseX, mouseY, false, 0, true, I18n.m_118938_((String)"tooltip.toms_storage.amount", (Object[])new Object[]{slot.stack.getQuantity()}));
            } else {
                this.renderItemInGui(st, slot.stack.getStack(), this.getGuiLeft() + slot.xDisplayPosition, this.getGuiTop() + slot.yDisplayPosition, mouseX, mouseY, false, 0, true, new String[0]);
            }
        }
        return mouseX >= this.getGuiLeft() + slot.xDisplayPosition - 1 && mouseY >= this.getGuiTop() + slot.yDisplayPosition - 1 && mouseX < this.getGuiLeft() + slot.xDisplayPosition + 17 && mouseY < this.getGuiTop() + slot.yDisplayPosition + 17;
    }

    private void drawStackSize(PoseStack st, Font fr, long size, int x, int y) {
        float scaleFactor = 0.6f;
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        String stackSize = ContainerStorageTerminal.formatNumber(size);
        st.m_85836_();
        st.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        st.m_85837_(0.0, 0.0, 450.0);
        float inverseScaleFactor = 1.0f / scaleFactor;
        int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.m_92895_(stackSize) * scaleFactor) * inverseScaleFactor);
        int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        fr.m_92750_(st, stackSize, (float)X, (float)Y, 0xFFFFFF);
        st.m_85849_();
        RenderSystem.m_69482_();
    }

    protected boolean needsScrollBars() {
        return ((ContainerStorageTerminal)this.m_6262_()).itemListClientSorted.size() > this.rowCount * 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        block15: {
            block14: {
                block12: {
                    block11: {
                        block13: {
                            if (this.slotIDUnderMouse <= -1) break block11;
                            if (this.isPullOne(mouseButton)) break block12;
                            if (!this.pullHalf(mouseButton)) break block13;
                            if (!((ContainerStorageTerminal)this.f_97732_).m_142621_().m_41619_()) {
                                this.storageSlotClick(ItemStack.f_41583_, GuiStorageTerminalBase.m_96637_() ? ContainerStorageTerminal.SlotAction.GET_QUARTER : ContainerStorageTerminal.SlotAction.GET_HALF, 0);
                                return true;
                            }
                            break block14;
                        }
                        if (!this.pullNormal(mouseButton)) return true;
                        if (!((ContainerStorageTerminal)this.f_97732_).m_142621_().m_41619_()) {
                            this.storageSlotClick(ItemStack.f_41583_, ContainerStorageTerminal.SlotAction.PULL_OR_PUSH_STACK, 0);
                            return true;
                        }
                        break block15;
                    }
                    if (GLFW.glfwGetKey((long)this.mc.m_91268_().m_85439_(), (int)32) != 0) {
                        this.storageSlotClick(ItemStack.f_41583_, ContainerStorageTerminal.SlotAction.SPACE_CLICK, 0);
                        return true;
                    }
                    if (mouseButton == 1) {
                        int n = this.searchField.f_93620_ - this.f_97735_;
                        int n2 = this.searchField.f_93621_ - this.f_97736_;
                        Objects.requireNonNull(this.getFont());
                        if (this.m_6774_(n, n2, 89, 9, mouseX, mouseY)) {
                            this.searchField.m_94144_("");
                            return true;
                        }
                    }
                    if (!this.searchField.m_6375_(mouseX, mouseY, mouseButton)) return super.m_6375_(mouseX, mouseY, mouseButton);
                    return true;
                }
                if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                int i = 0;
                while (i < ((ContainerStorageTerminal)this.m_6262_()).itemList.size()) {
                    if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.m_6262_()).itemList.get(i))) {
                        this.storageSlotClick(((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), ContainerStorageTerminal.SlotAction.PULL_ONE, this.isTransferOne(mouseButton) ? 1 : 0);
                        return true;
                    }
                    ++i;
                }
                return true;
            }
            if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
            if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
            int i = 0;
            while (i < ((ContainerStorageTerminal)this.m_6262_()).itemList.size()) {
                if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.m_6262_()).itemList.get(i))) {
                    this.storageSlotClick(((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), GuiStorageTerminalBase.m_96637_() ? ContainerStorageTerminal.SlotAction.GET_QUARTER : ContainerStorageTerminal.SlotAction.GET_HALF, 0);
                    return true;
                }
                ++i;
            }
            return true;
        }
        if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
        if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
        int i = 0;
        while (i < ((ContainerStorageTerminal)this.m_6262_()).itemList.size()) {
            if (((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.m_6262_()).itemList.get(i))) {
                this.storageSlotClick(((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), GuiStorageTerminalBase.m_96638_() ? ContainerStorageTerminal.SlotAction.SHIFT_PULL : ContainerStorageTerminal.SlotAction.PULL_OR_PUSH_STACK, 0);
                return true;
            }
            ++i;
        }
        return true;
    }

    protected void storageSlotClick(ItemStack slotStack, ContainerStorageTerminal.SlotAction act, int mod) {
        CompoundTag c = new CompoundTag();
        c.m_128365_("s", (Tag)slotStack.m_41739_(new CompoundTag()));
        c.m_128405_("a", act.ordinal());
        c.m_128344_("m", (byte)mod);
        CompoundTag msg = new CompoundTag();
        msg.m_128365_("a", (Tag)c);
        ((ContainerStorageTerminal)this.f_97732_).sendMessage(msg);
    }

    public boolean isPullOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1 && GuiStorageTerminalBase.m_96638_();
            }
            case RS: {
                return mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && !((ContainerStorageTerminal)this.f_97732_).m_142621_().m_41619_();
            }
        }
        return false;
    }

    public boolean isTransferOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return GuiStorageTerminalBase.m_96638_() && GuiStorageTerminalBase.m_96637_();
            }
            case RS: {
                return GuiStorageTerminalBase.m_96638_() && mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && GuiStorageTerminalBase.m_96638_();
            }
        }
        return false;
    }

    public boolean pullHalf(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1;
            }
            case RS: {
                return mouseButton == 1;
            }
            case DEF: {
                return mouseButton == 1 && ((ContainerStorageTerminal)this.f_97732_).m_142621_().m_41619_();
            }
        }
        return false;
    }

    public boolean pullNormal(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: 
            case RS: 
            case DEF: {
                return mouseButton == 0;
            }
        }
        return false;
    }

    private ControllMode ctrlm() {
        return ControllMode.VALUES[this.controllMode];
    }

    public final void renderItemInGui(PoseStack st, ItemStack stack, int x, int y, int mouseX, int mouseY, boolean hasBg, int color, boolean tooltip, String ... extraInfo) {
        if (stack != null) {
            if (!tooltip) {
                if (hasBg) {
                    GuiStorageTerminalBase.m_93172_((PoseStack)st, (int)x, (int)y, (int)16, (int)16, (int)(color | Integer.MIN_VALUE));
                }
                st.m_85837_(0.0, 0.0, 32.0);
                Font font = null;
                if (font == null) {
                    font = this.getFont();
                }
                RenderSystem.m_69482_();
                this.f_96542_.m_115203_(stack, x, y);
                this.f_96542_.m_115174_(font, stack, x, y, null);
            } else if (mouseX >= x - 1 && mouseY >= y - 1 && mouseX < x + 17 && mouseY < y + 17) {
                int i;
                List list = this.m_96555_(stack);
                if (extraInfo != null && extraInfo.length > 0) {
                    for (i = 0; i < extraInfo.length; ++i) {
                        list.add(new TextComponent(extraInfo[i]));
                    }
                }
                for (i = 0; i < list.size(); ++i) {
                    MutableComponent t2;
                    Component t = (Component)list.get(i);
                    MutableComponent mutableComponent = t2 = t instanceof MutableComponent ? (MutableComponent)t : t.m_6881_();
                    if (i == 0) {
                        list.set(i, t2.m_130940_(stack.m_41791_().f_43022_));
                        continue;
                    }
                    list.set(i, t2.m_130940_(ChatFormatting.GRAY));
                }
                this.m_96597_(st, list, mouseX, mouseY);
            }
        }
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.m_7379_();
            return true;
        }
        return !this.searchField.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.searchField.m_94204_() ? super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.m_5534_(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (((ContainerStorageTerminal)this.f_97732_).itemListClientSorted.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((ContainerStorageTerminal)this.f_97732_).scrollTo(this.currentScroll);
        return true;
    }

    public abstract ResourceLocation getGui();

    protected void m_7286_(PoseStack st, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getGui());
        this.m_93228_(st, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void onUpdateSearch(String text) {
    }

    @Override
    public void receive(CompoundTag tag) {
        ((ContainerStorageTerminal)this.f_97732_).receiveClientNBTPacket(tag);
        this.refreshItemList = true;
    }

    public Slot getSlotUnderMouse() {
        Slot s = super.getSlotUnderMouse();
        if (s != null) {
            return s;
        }
        if (this.slotIDUnderMouse > -1 && ((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack != null) {
            this.fakeSlotUnderMouse.f_40218_.m_6836_(0, ((ContainerStorageTerminal)this.m_6262_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack());
            return this.fakeSlotUnderMouse;
        }
        return null;
    }

    private static class FakeSlot
    extends Slot {
        private static final Container DUMMY = new SimpleContainer(1);

        public FakeSlot() {
            super(DUMMY, 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public boolean m_150651_(Player p_150652_) {
            return false;
        }

        public void m_5852_(ItemStack p_40240_) {
        }

        public ItemStack m_6201_(int p_40227_) {
            return ItemStack.f_41583_;
        }
    }

    public class GuiButton
    extends Button {
        protected int tile;
        protected int state;
        protected int texX;
        protected int texY;

        public GuiButton(int x, int y, int tile, Button.OnPress pressable) {
            super(x, y, 16, 16, null, pressable);
            this.texX = 194;
            this.texY = 30;
            this.tile = tile;
        }

        public void setX(int i) {
            this.f_93620_ = i;
        }

        public void m_6303_(PoseStack st, int mouseX, int mouseY, float pt) {
            if (this.f_93624_) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)GuiStorageTerminalBase.this.getGui());
                this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.m_93228_(st, this.f_93620_, this.f_93621_, this.texX + this.state * 16, this.texY + this.tile * 16, this.f_93618_, this.f_93619_);
            }
        }
    }
}

