/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.gui.GuiCraftingTerminal;
import com.tom.storagemod.gui.GuiFiltered;
import com.tom.storagemod.gui.GuiInventoryLink;
import com.tom.storagemod.gui.GuiLevelEmitter;
import com.tom.storagemod.gui.GuiStorageTerminal;
import com.tom.storagemod.item.ItemWirelessTerminal;
import com.tom.storagemod.model.BakedPaintedModel;
import com.tom.storagemod.tile.TileEntityPainted;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class StorageModClient {
    public static void clientSetup() {
        MenuScreens.m_96206_(StorageMod.storageTerminal, GuiStorageTerminal::new);
        MenuScreens.m_96206_(StorageMod.craftingTerminalCont, GuiCraftingTerminal::new);
        MenuScreens.m_96206_(StorageMod.filteredConatiner, GuiFiltered::new);
        MenuScreens.m_96206_(StorageMod.levelEmitterConatiner, GuiLevelEmitter::new);
        MenuScreens.m_96206_(StorageMod.inventoryLink, GuiInventoryLink::new);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(StorageModClient::bakeModels);
        ItemBlockRenderTypes.setRenderLayer((Block)StorageMod.paintedTrim, e -> true);
        ItemBlockRenderTypes.setRenderLayer((Block)StorageMod.invCableFramed, e -> true);
        ItemBlockRenderTypes.setRenderLayer((Block)StorageMod.invProxy, e -> true);
        ItemBlockRenderTypes.setRenderLayer((Block)StorageMod.invCableConnectorFramed, e -> true);
        ItemBlockRenderTypes.setRenderLayer((Block)StorageMod.levelEmitter, (RenderType)RenderType.m_110463_());
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        colors.m_92589_((state, world, pos, tintIndex) -> {
            if (world != null) {
                try {
                    BlockState mimicBlock = ((TileEntityPainted)world.m_7702_(pos)).getPaintedBlockState();
                    return colors.m_92577_(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, new Block[]{StorageMod.paintedTrim, StorageMod.invCableFramed, StorageMod.invProxy, StorageMod.invCableConnectorFramed});
        MinecraftForge.EVENT_BUS.addListener(StorageModClient::renderWorldLastEvent);
    }

    private static void bakeModels(ModelBakeEvent event) {
        StorageModClient.bindPaintedModel(event, (Block)StorageMod.paintedTrim);
        StorageModClient.bindPaintedModel(event, (Block)StorageMod.invCableFramed);
        StorageModClient.bindPaintedModel(event, (Block)StorageMod.invProxy);
        StorageModClient.bindPaintedModel(event, (Block)StorageMod.invCableConnectorFramed);
    }

    private static void bindPaintedModel(ModelBakeEvent event, Block blockFor) {
        ResourceLocation baseLoc = blockFor.delegate.name();
        blockFor.m_49965_().m_61056_().forEach(st -> {
            ModelResourceLocation resLoc = BlockModelShaper.m_110889_((ResourceLocation)baseLoc, (BlockState)st);
            event.getModelRegistry().put(resLoc, new BakedPaintedModel(blockFor, (BakedModel)event.getModelRegistry().get(resLoc)));
        });
    }

    private static void renderWorldLastEvent(RenderLevelLastEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (!ItemWirelessTerminal.isPlayerHolding((Player)player)) {
            return;
        }
        BlockHitResult lookingAt = (BlockHitResult)player.m_19907_((double)Config.wirelessRange, 0.0f, true);
        BlockState state = mc.f_91073_.m_8055_(lookingAt.m_82425_());
        if (state.m_204336_(StorageTags.REMOTE_ACTIVATE)) {
            BlockPos pos = lookingAt.m_82425_();
            Vec3 renderPos = mc.f_91063_.m_109153_().m_90583_();
            PoseStack ms = evt.getPoseStack();
            VertexConsumer buf = mc.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            StorageModClient.drawShape(ms, buf, state.m_60768_((BlockGetter)player.f_19853_, pos), (double)pos.m_123341_() - renderPos.f_82479_, (double)pos.m_123342_() - renderPos.f_82480_, (double)pos.m_123343_() - renderPos.f_82481_, 1.0f, 1.0f, 1.0f, 0.4f);
            mc.m_91269_().m_110104_().m_109912_(RenderType.m_110504_());
        }
    }

    private static void drawShape(PoseStack matrices, VertexConsumer vertexConsumer, VoxelShape voxelShape, double d, double e, double f, float g, float h, float i, float j) {
        PoseStack.Pose entry = matrices.m_85850_();
        voxelShape.m_83224_((k, l, m, n, o, p) -> {
            float q = (float)(n - k);
            float r = (float)(o - l);
            float s = (float)(p - m);
            float t = Mth.m_14116_((float)(q * q + r * r + s * s));
            vertexConsumer.m_85982_(entry.m_85861_(), (float)(k + d), (float)(l + e), (float)(m + f)).m_85950_(g, h, i, j).m_85977_(entry.m_85864_(), q /= t, r /= t, s /= t).m_5752_();
            vertexConsumer.m_85982_(entry.m_85861_(), (float)(n + d), (float)(o + e), (float)(p + f)).m_85950_(g, h, i, j).m_85977_(entry.m_85864_(), q, r, s).m_5752_();
        });
    }

    public static void tooltip(String key, List<Component> tooltip, Object ... args) {
        StorageModClient.tooltip(key, true, tooltip, args);
    }

    public static void tooltip(String key, boolean addShift, List<Component> tooltip, Object ... args) {
        if (Screen.m_96638_()) {
            String[] sp = I18n.m_118938_((String)("tooltip.toms_storage." + key), (Object[])args).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                tooltip.add((Component)new TextComponent(sp[i]));
            }
        } else if (addShift) {
            tooltip.add((Component)new TranslatableComponent("tooltip.toms_storage.hold_shift_for_info").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }
}

